/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.view;

import com.atlassian.gadgets.view.ViewType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class View {
    public static final View DEFAULT = new Builder().viewType(ViewType.DEFAULT).writable(true).build();
    private static final String WRITABLE_PARAM_NAME = "writable";
    private final ViewType viewType;
    private final boolean writable;
    private final Map<String, String> params;

    private View(Builder builder) {
        this.viewType = builder.viewType;
        String writableParam = (String)builder.paramMap.get(WRITABLE_PARAM_NAME);
        this.writable = writableParam == null ? false : Boolean.valueOf(writableParam);
        this.params = Collections.unmodifiableMap(new HashMap(builder.paramMap));
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Map<String, String> paramsAsMap() {
        return this.params;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ViewType viewType;
        private Map<String, String> paramMap = new HashMap<String, String>();

        public Builder viewType(ViewType viewType) {
            this.viewType = viewType;
            return this;
        }

        public Builder writable(boolean writable) {
            this.paramMap.put(View.WRITABLE_PARAM_NAME, Boolean.toString(writable));
            return this;
        }

        public Builder addViewParam(String name, String value) {
            this.paramMap.put(name, value);
            return this;
        }

        public Builder addViewParams(Map<String, String> params) {
            this.paramMap.putAll(params);
            return this;
        }

        public View build() {
            return new View(this);
        }
    }
}

