/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.webhook;

import com.atlassian.crowd.model.webhook.Webhook;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookPinger {
    private static final Logger logger = LoggerFactory.getLogger(WebhookPinger.class);
    private final HttpClient httpClient;

    public WebhookPinger() {
        this(new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager()));
    }

    public WebhookPinger(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(Webhook webhook) throws IOException {
        int statusCode;
        PostMethod method;
        logger.debug("Pinging Webhook {} at endpoint {}", (Object)webhook.getId(), (Object)webhook.getEndpointUrl());
        try {
            method = new PostMethod(webhook.getEndpointUrl());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to parse webhook endpoint url for ping (endpoint url might be invalid): " + webhook.getEndpointUrl(), e);
        }
        if (webhook.getToken() != null) {
            method.setRequestHeader("Authorization", "Basic " + webhook.getToken());
        }
        try {
            statusCode = this.httpClient.executeMethod((HttpMethod)method);
        }
        finally {
            method.releaseConnection();
        }
        if (!WebhookPinger.isSuccessfulStatusCode(statusCode)) {
            throw new IOException("Webhook endpoint returned status code " + statusCode);
        }
        logger.debug("Webhook {} successfully pinged at endpoint {}", (Object)webhook.getId(), (Object)webhook.getEndpointUrl());
    }

    private static boolean isSuccessfulStatusCode(int statusCode) {
        return statusCode / 100 == 2;
    }
}

