/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.core.event.listener;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.event.user.UserAuthenticationSucceededEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.EntityComparator;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.event.api.EventListener;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoGroupAdderListener {
    protected static final String AUTO_GROUPS_ADDED = "autoGroupsAdded";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DirectoryManager directoryManager;

    public AutoGroupAdderListener(DirectoryManager directoryManager) {
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager, (Object)"directoryManager");
    }

    @EventListener
    public void handleEvent(UserAuthenticatedEvent event) {
        Directory directory = event.getDirectory();
        User user = event.getUser();
        this.handleEvent(directory, user);
    }

    @EventListener
    public void handleEvent(UserAuthenticationSucceededEvent event) {
        User user = event.getRemotePrincipal();
        try {
            this.handleEvent(this.directoryManager.findDirectoryById(user.getDirectoryId()), user);
        }
        catch (DirectoryNotFoundException e) {
            this.logger.error("Could not find directory " + user.getDirectoryId(), (Throwable)e);
        }
    }

    private void handleEvent(Directory directory, User user) {
        String concatenatedGroupNames = directory.getValue("autoAddGroups");
        if (StringUtils.isNotBlank((CharSequence)concatenatedGroupNames)) {
            String[] groups = StringUtils.split((String)concatenatedGroupNames, (char)'|');
            try {
                UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(directory.getId().longValue(), user.getName());
                if (Boolean.parseBoolean(userWithAttributes.getValue(AUTO_GROUPS_ADDED))) {
                    return;
                }
                TreeSet<String> currentMemberships = new TreeSet<String>(EntityComparator.of(String.class));
                currentMemberships.addAll(this.searchDirectGroupMemberships(directory.getId(), user));
                for (String groupName : groups) {
                    try {
                        if (currentMemberships.contains(groupName)) continue;
                        this.directoryManager.addUserToGroup(directory.getId().longValue(), user.getName(), groupName);
                    }
                    catch (GroupNotFoundException e) {
                        this.logger.error("Could not auto add user to group: " + e.getMessage(), (Throwable)e);
                    }
                    catch (OperationFailedException e) {
                        this.logger.error("Could not access directory: " + e.getMessage(), (Throwable)e);
                    }
                    catch (UserNotFoundException e) {
                        this.logger.error("Could not auto add user to group: " + e.getMessage(), (Throwable)e);
                    }
                    catch (ReadOnlyGroupException e) {
                        this.logger.error("Could not auto add user to group: " + e.getMessage(), (Throwable)e);
                    }
                    catch (DirectoryNotFoundException e) {
                        this.logger.error("Could not find directory " + directory.getId(), (Throwable)e);
                    }
                    catch (DirectoryPermissionException e) {
                        this.logger.error("You have group <" + groupName + "> to be auto-added for the user <" + user.getName() + ">, but the directory does not have permission for Group updates.");
                    }
                    catch (MembershipAlreadyExistsException e) {
                        this.logger.error("Could not auto add user to group because membership already exists", (Throwable)e);
                    }
                }
                this.directoryManager.storeUserAttributes(directory.getId().longValue(), user.getName(), (Map)ImmutableMap.of((Object)AUTO_GROUPS_ADDED, Collections.singleton(Boolean.TRUE.toString())));
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error("Could not instantiate directory: " + e.getMessage(), (Throwable)e);
            }
            catch (OperationFailedException e) {
                this.logger.error("Could not access directory: " + e.getMessage(), (Throwable)e);
            }
            catch (UserNotFoundException e) {
                this.logger.error("Could not access user: " + e.getMessage(), (Throwable)e);
            }
            catch (DirectoryNotFoundException e) {
                this.logger.error("Could not find directory " + directory.getId(), (Throwable)e);
            }
            catch (DirectoryPermissionException e) {
                this.logger.error("Could not store auto-added groups attributes for user <" + user.getName() + ">  because directory does not have permission for User updates.");
            }
        }
    }

    private List<String> searchDirectGroupMemberships(long directoryId, User user) throws OperationFailedException, DirectoryNotFoundException {
        return this.directoryManager.searchDirectGroupRelationships(directoryId, QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.user(), (String)user.getName()));
    }
}

