/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.util;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.ArrayMap;
import android.util.Log;
import android.widget.Toast;
import com.antfortune.freeline.resources.MonkeyPatcher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Restarter {
    private static final String LOG_TAG = "Freeline.Restarter";

    public static void restartActivityOnUiThread(final Activity activity) {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (Log.isLoggable((String)Restarter.LOG_TAG, (int)2)) {
                    Log.v((String)Restarter.LOG_TAG, (String)"Resources updated: notify activities");
                }
                Restarter.updateActivity(activity);
            }
        });
    }

    private static void restartActivity(Activity activity) {
        if (Log.isLoggable((String)LOG_TAG, (int)2)) {
            Log.v((String)LOG_TAG, (String)("About to restart " + activity.getClass().getSimpleName()));
        }
        while (activity.getParent() != null) {
            if (Log.isLoggable((String)LOG_TAG, (int)2)) {
                Log.v((String)LOG_TAG, (String)(activity.getClass().getSimpleName() + " is not a top level activity; restarting " + activity.getParent().getClass().getSimpleName() + " instead"));
            }
            activity = activity.getParent();
        }
        activity.recreate();
    }

    public static void restartApp(Context appContext, Collection<Activity> knownActivities, boolean toast) {
        if (!knownActivities.isEmpty()) {
            Activity foreground = Restarter.getForegroundActivity(appContext);
            if (foreground != null) {
                if (toast) {
                    Restarter.showToast(foreground, "Restarting app to apply incompatible changes");
                }
                if (Log.isLoggable((String)LOG_TAG, (int)2)) {
                    Log.v((String)LOG_TAG, (String)"RESTARTING APP");
                }
                Activity context = foreground;
                Intent intent = new Intent((Context)context, foreground.getClass());
                int intentId = 0;
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)intentId, (Intent)intent, (int)0x10000000);
                AlarmManager mgr = (AlarmManager)context.getSystemService("alarm");
                mgr.set(1, System.currentTimeMillis() + 100L, pendingIntent);
                if (Log.isLoggable((String)LOG_TAG, (int)2)) {
                    Log.v((String)LOG_TAG, (String)("Scheduling activity " + foreground + " to start after exiting process"));
                }
            } else {
                Restarter.showToast(knownActivities.iterator().next(), "Unable to restart app");
                if (Log.isLoggable((String)LOG_TAG, (int)2)) {
                    Log.v((String)LOG_TAG, (String)"Couldn't find any foreground activities to restart for resource refresh");
                }
            }
            System.exit(0);
        }
    }

    static void showToast(final Activity activity, final String text) {
        if (Log.isLoggable((String)LOG_TAG, (int)2)) {
            Log.v((String)LOG_TAG, (String)("About to show toast for activity " + activity + ": " + text));
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        Context base;
                        Context context = activity.getApplicationContext();
                        if (context instanceof ContextWrapper && (base = ((ContextWrapper)context).getBaseContext()) == null) {
                            if (Log.isLoggable((String)Restarter.LOG_TAG, (int)5)) {
                                Log.w((String)Restarter.LOG_TAG, (String)"Couldn't show toast: no base context");
                            }
                            return;
                        }
                        int duration = 0;
                        if (text.length() >= 60 || text.indexOf(10) != -1) {
                            duration = 1;
                        }
                        Toast.makeText((Context)activity, (CharSequence)text, (int)duration).show();
                    }
                    catch (Throwable e) {
                        if (!Log.isLoggable((String)Restarter.LOG_TAG, (int)5)) break block5;
                        Log.w((String)Restarter.LOG_TAG, (String)"Couldn't show toast", (Throwable)e);
                    }
                }
            }
        });
    }

    public static Activity getForegroundActivity(Context context) {
        List<Activity> list = Restarter.getActivities(context, true);
        return list.isEmpty() ? null : list.get(0);
    }

    public static List<Activity> getActivities(Context context, boolean foregroundOnly) {
        ArrayList<Activity> list = new ArrayList<Activity>();
        try {
            Collection c;
            HashMap activities;
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = MonkeyPatcher.getActivityThread(context, activityThreadClass);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            Object collection = activitiesField.get(activityThread);
            if (collection instanceof HashMap) {
                activities = (HashMap)collection;
                c = activities.values();
            } else if (Build.VERSION.SDK_INT >= 19 && collection instanceof ArrayMap) {
                activities = (ArrayMap)collection;
                c = activities.values();
            } else {
                return list;
            }
            for (Object activityRecord : c) {
                Class<?> activityRecordClass = activityRecord.getClass();
                if (foregroundOnly) {
                    Field pausedField = activityRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (pausedField.getBoolean(activityRecord)) continue;
                }
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                if (activity == null) continue;
                list.add(activity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    private static void updateActivity(Activity activity) {
        Restarter.restartActivity(activity);
    }

    public static void showToastWhenPossible(Context context, String message) {
        Activity activity = Restarter.getForegroundActivity(context);
        if (activity != null) {
            Restarter.showToast(activity, message);
        } else {
            Restarter.showToastWhenPossible(context, message, 10);
        }
    }

    private static void showToastWhenPossible(final Context context, final String message, final int remainingAttempts) {
        Looper mainLooper = Looper.getMainLooper();
        Handler handler = new Handler(mainLooper);
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Activity activity = Restarter.getForegroundActivity(context);
                if (activity != null) {
                    Restarter.showToast(activity, message);
                } else if (remainingAttempts > 0) {
                    Restarter.showToastWhenPossible(context, message, remainingAttempts - 1);
                }
            }
        }, 1000L);
    }
}

