/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.router;

import com.antfortune.freeline.router.ISchemaAction;
import com.antfortune.freeline.server.EmbedHttpServer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Router {
    private static Router sInstance;
    private Map<String, ISchemaAction> mSchemaMap = new HashMap<String, ISchemaAction>();

    private Router() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Router getInstance() {
        Class<Router> clazz = Router.class;
        synchronized (Router.class) {
            if (sInstance == null) {
                sInstance = new Router();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void registerSchema(ISchemaAction schemaAction) {
        if (schemaAction != null) {
            this.mSchemaMap.put(schemaAction.getDescription(), schemaAction);
        }
    }

    public boolean dispatch(String method, String path, HashMap<String, String> headers, Map<String, String> queries, InputStream input, EmbedHttpServer.ResponseOutputStream response) throws Exception {
        if (queries == null || queries.size() == 0) {
            return false;
        }
        String description = queries.get("description");
        for (String name : this.mSchemaMap.keySet()) {
            if (!name.equals(description)) continue;
            this.mSchemaMap.get(name).handle(method, path, headers, queries, input, response);
            return true;
        }
        return false;
    }
}

