/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import com.antfortune.freeline.FreelineCore;
import com.antfortune.freeline.util.ReflectUtil;
import java.lang.reflect.Constructor;

public class FreelineApplication
extends Application {
    protected static final String TAG = "FreelineApplication";
    private Class freelineConfigClazz;
    private Application realApplication;

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"FreelineApplication#onCreate()");
        this.initFreelineConfig();
        this.createRealApplication();
        FreelineCore.init((Application)this, this.realApplication);
        this.startRealApplication();
    }

    public Context createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Context c = this.realApplication.createPackageContext(packageName, flags);
        return c == null ? this.realApplication : c;
    }

    private void startRealApplication() {
        if (this.realApplication != null) {
            try {
                ReflectUtil.invokeMethod(Application.class, this.realApplication, "attach", new Class[]{Context.class}, new Object[]{this.getBaseContext()});
                Log.d((String)TAG, (String)"realApplication#attach(Context)");
            }
            catch (Exception e) {
                FreelineCore.printStackTrace(e);
                Log.e((String)TAG, (String)"attach with realApplication error");
            }
            this.realApplication.onCreate();
            Log.d((String)TAG, (String)"realApplication#onCreate()");
        }
    }

    private void initFreelineConfig() {
        try {
            this.freelineConfigClazz = Class.forName("com.antfortune.freeline.FreelineConfig");
        }
        catch (Exception e) {
            FreelineCore.printStackTrace(e);
            Log.e((String)TAG, (String)"initFreelineConfig error");
        }
    }

    private String getConfigValue(String fieldName) {
        try {
            return ReflectUtil.getStaticFieldValue(this.freelineConfigClazz, fieldName).toString();
        }
        catch (Exception e) {
            FreelineCore.printStackTrace(e);
            Log.e((String)TAG, (String)"get config value error");
            return "";
        }
    }

    private void createRealApplication() {
        String applicationClass = this.getConfigValue("applicationClass");
        if (TextUtils.isEmpty((CharSequence)applicationClass)) {
            this.realApplication = new Application();
            Log.d((String)TAG, (String)"create empty application.");
        } else {
            try {
                Class<?> realClass = Class.forName(applicationClass);
                Constructor<?> constructor = realClass.getConstructor(new Class[0]);
                this.realApplication = (Application)constructor.newInstance(new Object[0]);
                Log.d((String)TAG, (String)("create application: " + applicationClass));
            }
            catch (Exception e) {
                FreelineCore.printStackTrace(e);
                Log.e((String)TAG, (String)"create real application error");
            }
        }
    }
}

