/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import com.antfortune.freeline.MiddlewareActivity;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;

public class ActivityManager {
    private static final String TAG = "Freeline.ActManager";
    public static final int ACTIVITY_NONE = 0;
    public static final int ACTIVITY_CREATED = 1;
    public static final int ACTIVITY_STARTED = 2;
    public static final int ACTIVITY_RESUMED = 3;
    private static final WeakHashMap<Activity, Integer> sActivitiesRefs = new WeakHashMap();
    private static long sFirstTaskId = 0L;
    private static final Application.ActivityLifecycleCallbacks sLifecycleCallback = new Application.ActivityLifecycleCallbacks(){

        public void onActivityStopped(Activity activity) {
            sActivitiesRefs.put(activity, 1);
        }

        public void onActivityStarted(Activity activity) {
            sActivitiesRefs.put(activity, 2);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityResumed(Activity activity) {
            sActivitiesRefs.put(activity, 3);
        }

        public void onActivityPaused(Activity activity) {
            sActivitiesRefs.put(activity, 2);
        }

        public void onActivityDestroyed(Activity activity) {
            sActivitiesRefs.remove(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            sActivitiesRefs.put(activity, 1);
            if (sFirstTaskId == 0L) {
                sFirstTaskId = activity.getTaskId();
            }
        }
    };

    public static void initApplication(Application app) {
        app.registerActivityLifecycleCallbacks(sLifecycleCallback);
    }

    public static boolean restart(final Context context, boolean confirm) {
        Activity top = ActivityManager.getTopActivity();
        if (top instanceof MiddlewareActivity) {
            ((MiddlewareActivity)top).reset();
            return true;
        }
        try {
            Intent e = new Intent(context, MiddlewareActivity.class);
            e.setFlags(0x10000000);
            e.putExtra("reset", confirm);
            context.startActivity(e);
            return true;
        }
        catch (Exception exception) {
            final String str = "Fail to increment build, make sure you have <Activity android:name=\"" + MiddlewareActivity.class.getName() + "\"/> registered in AndroidManifest.xml";
            Log.e((String)TAG, (String)str);
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)context, (CharSequence)str, (int)1).show();
                }
            });
            return false;
        }
    }

    public static void restartCurrentActivity() {
        final Activity top = ActivityManager.getTopActivity();
        if (top instanceof Activity) {
            final Activity ac = top;
            Intent i = ac.getIntent();
            boolean rst = false;
            Log.i((String)TAG, (String)("activity " + ac.getComponentName() + " has singleTask:" + rst));
            i.addFlags(65536);
            ac.overridePendingTransition(0, 0);
            ac.startActivity(i);
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    Log.e((String)ActivityManager.TAG, (String)("first task id " + sFirstTaskId + " top actvitiy id " + ac.getTaskId()));
                    Activity a = ActivityManager.getTopActivity();
                    Log.e((String)ActivityManager.TAG, (String)("last top: " + top + " now top :" + a + " activity size :" + ActivityManager.getAllActivities().length));
                    if (a == ac) {
                        ac.recreate();
                        Log.d((String)ActivityManager.TAG, (String)("restart :" + ac.getComponentName()));
                    } else {
                        ac.finish();
                        ac.overridePendingTransition(0, 0);
                        Log.d((String)ActivityManager.TAG, (String)("finish :" + ac.getComponentName()));
                    }
                }
            }, 200L);
        }
    }

    public static void restartActivity() {
        Activity[] activities = ActivityManager.getAllActivities();
        if (activities != null && activities.length > 0) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Activity[] activities;
                    Exception err = null;
                    for (Activity a : activities = ActivityManager.getAllActivities()) {
                        try {
                            a.recreate();
                            Log.d((String)ActivityManager.TAG, (String)("restartActivity :" + a.getComponentName()));
                        }
                        catch (Exception exception) {
                            err = exception;
                        }
                    }
                    if (err != null) {
                        throw new RuntimeException(err);
                    }
                }
            });
        }
    }

    public static Activity[] getAllActivities() {
        ArrayList<Activity> list = new ArrayList<Activity>();
        for (Map.Entry<Activity, Integer> e : sActivitiesRefs.entrySet()) {
            Activity a = e.getKey();
            if (a == null || e.getValue() <= 0) continue;
            list.add(a);
        }
        return list.toArray(new Activity[list.size()]);
    }

    public static Activity getTopActivity() {
        Activity r = null;
        for (Map.Entry<Activity, Integer> e : sActivitiesRefs.entrySet()) {
            Activity a = e.getKey();
            if (a == null || e.getValue() != 3) continue;
            r = a;
        }
        return r;
    }
}

