/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.server;

import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class EmbedHttpServer
implements Runnable {
    private int port;
    private ServerSocket serverSocket;

    public EmbedHttpServer(int port) {
        this.port = port;
    }

    public void start() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.port);
            new Thread((Runnable)this, "embed-http-server").start();
        }
    }

    public void stop() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
    }

    protected void handle(String method, String path, HashMap<String, String> headers, Map<String, String> queries, InputStream input, ResponseOutputStream response) throws Exception {
    }

    @Override
    public void run() {
        ServerSocket ss = this.serverSocket;
        while (ss == this.serverSocket) {
            block12: {
                Socket conn = null;
                try {
                    int l;
                    conn = ss.accept();
                    String method = null;
                    String path = null;
                    HashMap<String, String> headers = new HashMap<String, String>();
                    InputStream ins = conn.getInputStream();
                    StringBuilder sb = new StringBuilder(512);
                    while ((l = ins.read()) != -1) {
                        if (l == 10) {
                            int i;
                            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\r') {
                                sb.setLength(sb.length() - 1);
                            }
                            if (sb.length() == 0) break;
                            if (method == null) {
                                i = sb.indexOf(" ");
                                method = sb.substring(0, i);
                                int j = sb.lastIndexOf(" HTTP/");
                                path = sb.substring(i + 1, j).trim();
                            } else {
                                i = sb.indexOf(":");
                                String name = sb.substring(0, i).trim();
                                String val = sb.substring(i + 1).trim();
                                headers.put(name, val);
                            }
                            sb.setLength(0);
                            continue;
                        }
                        sb.append((char)l);
                    }
                    int contentLength = 0;
                    String str = (String)headers.get("Content-Length");
                    if (str != null) {
                        contentLength = Integer.parseInt(str);
                    }
                    OutputStream os = conn.getOutputStream();
                    str = (String)headers.get("Expect");
                    if ("100-Continue".equalsIgnoreCase(str)) {
                        os.write("HTTP/1.1 100 Continue\r\n\r\n".getBytes("ASCII"));
                        os.flush();
                    }
                    BodyInputStream input = new BodyInputStream(ins, contentLength);
                    ResponseOutputStream response = new ResponseOutputStream(os);
                    Map<String, String> queries = EmbedHttpServer.parsePath(path);
                    this.handle(method, path, headers, queries, input, response);
                    response.close();
                    conn.close();
                    conn = null;
                }
                catch (Exception e) {
                    if (conn == null) break block12;
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (ss.isBound() && !ss.isClosed()) continue;
            this.serverSocket = null;
        }
    }

    private static Map<String, String> parsePath(String path) {
        String[] arr;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int descriptionIndex = path.indexOf("/");
        if (descriptionIndex == -1) {
            return null;
        }
        String description = path.substring(descriptionIndex + 1);
        HashMap<String, String> queries = new HashMap<String, String>();
        int queryIndex = description.indexOf("?");
        if (queryIndex == -1) {
            queries.put("description", description);
        } else {
            queries.put("description", description.substring(0, queryIndex));
            description = description.substring(queryIndex + 1);
        }
        for (String segment : arr = description.split("&")) {
            String[] query = segment.split("=");
            if (query.length == 2) {
                queries.put(query[0], query[1]);
                continue;
            }
            if (query.length != 1) continue;
            queries.put(query[0], "");
        }
        return queries;
    }

    public static class ResponseOutputStream
    extends OutputStream {
        private static final byte[] CRLF = new byte[]{13, 10};
        private OutputStream os;
        private int lv;

        public ResponseOutputStream(OutputStream os) {
            this.os = os;
        }

        public void setStatusCode(int statusCode) throws IOException {
            switch (statusCode) {
                case 200: {
                    this.setStatusLine("200 OK");
                    break;
                }
                case 201: {
                    this.setStatusLine("201 Created");
                    break;
                }
                case 202: {
                    this.setStatusLine("202 Accepted");
                    break;
                }
                case 301: {
                    this.setStatusLine("301 Moved Permanently");
                    break;
                }
                case 304: {
                    this.setStatusLine("304 Not Modified");
                    break;
                }
                case 400: {
                    this.setStatusLine("400 Bad Request");
                    break;
                }
                case 401: {
                    this.setStatusLine("401 Unauthorized");
                    break;
                }
                case 403: {
                    this.setStatusLine("403 Forbidden");
                    break;
                }
                case 404: {
                    this.setStatusLine("404 Not Found");
                    break;
                }
                case 405: {
                    this.setStatusLine("405 Method Not Allowed");
                    break;
                }
                case 500: {
                    this.setStatusLine("500 Internal Server Error");
                    break;
                }
                case 501: {
                    this.setStatusLine("501 Not Implemented");
                    break;
                }
                default: {
                    this.setStatusLine(String.valueOf(statusCode));
                }
            }
        }

        public void setStatusLine(String statusLine) throws IOException {
            if (this.lv != 0) {
                throw new IOException("status line is already set");
            }
            this.os.write("HTTP/1.1 ".getBytes("ASCII"));
            this.os.write(statusLine.getBytes("ASCII"));
            this.os.write(CRLF);
            this.lv = 1;
        }

        public void setHeader(String name, String value) throws IOException {
            if (this.lv < 1) {
                this.setStatusCode(200);
            }
            if (this.lv != 1) {
                throw new IOException("headers is already set");
            }
            this.os.write(name.getBytes("ASCII"));
            this.os.write(58);
            this.os.write(32);
            this.os.write(value.getBytes("ASCII"));
            this.os.write(CRLF);
        }

        public void setContentLength(int value) throws IOException {
            this.setHeader("Content-Length", String.valueOf(value));
        }

        public void setContentEncoding(String value) throws IOException {
            this.setHeader("Content-Encoding", value);
        }

        public void setContentType(String value) throws IOException {
            this.setHeader("Content-Type", value);
        }

        public void setContentTypeText() throws IOException {
            this.setContentType("text/plain");
        }

        public void setContentTypeTextUtf8() throws IOException {
            this.setContentType("text/plain; charset=utf-8");
        }

        public void setContentTypeHtml() throws IOException {
            this.setContentType("text/html");
        }

        public void setContentTypeHtmlUtf8() throws IOException {
            this.setContentType("text/html; charset=utf-8");
        }

        public void setContentTypeBinary() throws IOException {
            this.setContentType("application/octet-stream");
        }

        public void setContentTypeJson() throws IOException {
            this.setContentType("application/json");
        }

        public void setContentTypeXml() throws IOException {
            this.setContentType("text/xml");
        }

        public void setContentTypeZip() throws IOException {
            this.setContentType("application/zip");
        }

        public void setContentTypeJpeg() throws IOException {
            this.setContentType("image/jpeg");
        }

        public void setContentTypePng() throws IOException {
            this.setContentType("image/png");
        }

        @Override
        public void write(int b) throws IOException {
            if (this.lv < 1) {
                this.setStatusCode(200);
            }
            if (this.lv < 2) {
                this.os.write(CRLF);
                this.lv = 2;
            }
            this.os.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.lv < 1) {
                this.setStatusCode(200);
            }
            if (this.lv < 2) {
                this.os.write(CRLF);
                this.lv = 2;
            }
            this.os.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.lv < 1) {
                this.setStatusCode(404);
            }
            if (this.lv < 2) {
                this.os.write(CRLF);
                this.lv = 2;
            }
            if (this.lv < 3) {
                this.os.close();
                this.lv = 3;
            }
        }
    }

    private static class BodyInputStream
    extends InputStream {
        private InputStream ins;
        private int n;

        public BodyInputStream(InputStream ins, int n) {
            this.ins = ins;
            this.n = n;
        }

        @Override
        public int available() throws IOException {
            return this.n;
        }

        @Override
        public int read() throws IOException {
            if (this.n <= 0) {
                return -1;
            }
            int r = this.ins.read();
            if (r != -1) {
                --this.n;
            }
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.n <= 0) {
                return -1;
            }
            int l = this.ins.read(b, off, len < this.n ? len : this.n);
            if (l != -1) {
                this.n -= l;
            }
            return l;
        }

        @Override
        public long skip(long n) throws IOException {
            throw new IOException("unsupported");
        }

        @Override
        public void close() throws IOException {
            this.ins.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("unsupported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

