/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.router.schema;

import android.os.Build;
import android.util.Log;
import com.antfortune.freeline.FreelineCore;
import com.antfortune.freeline.router.ISchemaAction;
import com.antfortune.freeline.server.EmbedHttpServer;
import com.antfortune.freeline.server.LongLinkServer;
import com.antfortune.freeline.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class PushResourceSchema
implements ISchemaAction {
    private static final String TAG = "Freeline.PushResource";

    @Override
    public String getDescription() {
        return "pushResource";
    }

    @Override
    public void handle(String method, String path, HashMap<String, String> headers, Map<String, String> queries, InputStream input, EmbedHttpServer.ResponseOutputStream response) throws Exception {
        boolean fullBuild;
        Log.d((String)TAG, (String)("receive res " + path));
        String bundleName = queries.get("bundleId");
        boolean bl = fullBuild = Build.VERSION.SDK_INT <= 19;
        if (fullBuild) {
            Log.d((String)TAG, (String)"receive full res pck command");
        }
        Log.d((String)TAG, (String)("bundle id " + bundleName));
        String destPath = FreelineCore.getDynamicInfoTempPath(bundleName);
        File lastPathFile = new File(FreelineCore.getBundleFilePathByPackageId(bundleName));
        Log.i((String)TAG, (String)("bundle last time :" + lastPathFile.lastModified()));
        File destFile = new File(destPath);
        File pendingFile = new File(destPath + ".bak");
        int count = 0;
        try {
            int l;
            if (!pendingFile.exists()) {
                pendingFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(pendingFile);
            byte[] buf = new byte[4096];
            while ((l = input.read(buf)) != -1) {
                fos.write(buf, 0, l);
                count += l;
            }
            fos.close();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.getStackTrace().toString());
            response.setStatusCode(500);
            return;
        }
        if (fullBuild) {
            FileUtils.rm(destFile);
            boolean rst2 = pendingFile.renameTo(destFile);
            Log.d((String)TAG, (String)("delete pending file rename rst :" + rst2));
        } else {
            if (destFile.exists()) {
                if (!destFile.isDirectory()) {
                    File temp = new File(destFile.getAbsolutePath() + ".temp");
                    boolean rst = destFile.renameTo(temp);
                    Log.d((String)TAG, (String)("dest File renameTo " + temp.getAbsolutePath() + " rst:" + rst));
                    destFile = new File(destPath);
                    if (rst) {
                        long s = System.currentTimeMillis();
                        destFile.mkdirs();
                        FileUtils.unzip(temp, destFile);
                        Log.d((String)TAG, (String)("unzip file " + temp + " to " + destPath + " rst:" + rst + " last:" + (System.currentTimeMillis() - s)));
                        Log.d((String)TAG, (String)("after unzip ,dir file size =" + destFile.list().length));
                    }
                }
            } else {
                try {
                    long s = System.currentTimeMillis();
                    destFile.mkdirs();
                    FileUtils.unzip(lastPathFile, destFile);
                    Log.d((String)TAG, (String)("unzip old file " + lastPathFile + " to  " + destFile.getAbsolutePath() + " last:" + (System.currentTimeMillis() - s)));
                    Log.d((String)TAG, (String)("after unzip ,dir file size =" + destFile.list().length));
                }
                catch (Exception e) {
                    FreelineCore.printStackTrace(e);
                }
            }
            long s = System.currentTimeMillis();
            FileUtils.unzip(pendingFile, destFile);
            FileUtils.rm(pendingFile);
            Log.d((String)TAG, (String)("sync res increment files to  " + destFile.getAbsolutePath() + " last:" + (System.currentTimeMillis() - s)));
        }
        LongLinkServer.setBundleName(bundleName);
        LongLinkServer.setDstPath(destPath);
        LongLinkServer.markResourcesChanged();
        response.setStatusCode(201);
        Log.d((String)TAG, (String)("increment resources file received (" + count + " bytes)"));
    }
}

