/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.router.schema;

import android.util.Log;
import com.antfortune.freeline.FreelineCore;
import com.antfortune.freeline.router.ISchemaAction;
import com.antfortune.freeline.server.EmbedHttpServer;
import com.antfortune.freeline.server.LongLinkServer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class CloseLonglinkSchema
implements ISchemaAction {
    private static final String TAG = "Freeline.CloseLongLink";

    @Override
    public String getDescription() {
        return "closeLongLink";
    }

    @Override
    public void handle(String method, String path, HashMap<String, String> headers, Map<String, String> queries, InputStream input, EmbedHttpServer.ResponseOutputStream response) throws Exception {
        String lastSync = queries.get("lastSync");
        FreelineCore.saveLastDynamicSyncId(Long.parseLong(lastSync));
        Log.i((String)TAG, (String)("save last sync value: " + lastSync));
        boolean forceRestart = queries.containsKey("restart");
        if (forceRestart) {
            Log.i((String)TAG, (String)"find restart marker, appliacation will restart.");
        }
        if (LongLinkServer.isDexChanged() || LongLinkServer.isResourcesChanged() || LongLinkServer.isNativeChanged()) {
            if (LongLinkServer.isDexChanged() || LongLinkServer.isNativeChanged() || forceRestart) {
                if (LongLinkServer.isDexChanged()) {
                    Log.i((String)TAG, (String)"with dex changes, need to restart the process (activity stack will be reserved)");
                } else if (LongLinkServer.isNativeChanged()) {
                    Log.i((String)TAG, (String)"with .so files changed, need to restart the process (activity stack will be reserved)");
                }
                FreelineCore.restartApplication(LongLinkServer.getBundleName(), LongLinkServer.getDstPath(), LongLinkServer.getDynamicDexPath(), LongLinkServer.getOptDirPath());
                LongLinkServer.resetDexChangedFlag();
                LongLinkServer.resetResourcesChangedFlag();
                LongLinkServer.resetNativeChangedFlag();
            } else if (LongLinkServer.isResourcesChanged()) {
                FreelineCore.clearResourcesCache();
                FreelineCore.updateActivity(LongLinkServer.getBundleName(), LongLinkServer.getDstPath());
                LongLinkServer.resetResourcesChangedFlag();
                Log.i((String)TAG, (String)"with only res changes, just recreate the running activity.");
            }
            response.setStatusCode(200);
        }
    }
}

