/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import com.antfortune.freeline.router.Router;
import com.antfortune.freeline.server.LongLinkServer;
import java.util.concurrent.TimeUnit;

public class FreelineService
extends Service {
    private static final String LOG_TAG = "Freeline.Service";
    private static final int SERVICE_NOTIFICATION_ID = 8861;
    private static final String ACTION_KEEP_LIVE = ".Notification_RTC_WAKEUP_PUSH";
    private AlarmManager am = null;
    private PendingIntent mCheckSender = null;

    public void onCreate() {
        super.onCreate();
        this.am = (AlarmManager)this.getSystemService("alarm");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.i((String)LOG_TAG, (String)("onStartCommand Received start id " + startId + ", intent: " + intent));
        LongLinkServer.start((Context)this.getApplication(), Router.getInstance());
        String marker = intent.getStringExtra("wakeup");
        if (TextUtils.isEmpty((CharSequence)marker)) {
            try {
                this.setForegroundService();
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"setForegroundService fail", (Throwable)e);
            }
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        try {
            this.stopForeground(true);
            this.startAlarmTimer(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"stopForeground fail", (Throwable)e);
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void startAlarmTimer(long nextTime) {
        Log.i((String)LOG_TAG, (String)("startAlarmTimer ELAPSED_REALTIME_WAKEUP! nextTime=" + nextTime));
        Intent intent = new Intent();
        intent.setAction(this.getPackageName() + ACTION_KEEP_LIVE);
        this.mCheckSender = PendingIntent.getBroadcast((Context)this, (int)100, (Intent)intent, (int)0);
        try {
            if (this.am != null && this.mCheckSender != null) {
                this.am.set(0, System.currentTimeMillis() + nextTime, this.mCheckSender);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"startAlarmTimer fail", (Throwable)e);
        }
    }

    private void setForegroundService() {
        if (Build.VERSION.SDK_INT < 18) {
            this.startForeground(8861, new Notification());
        } else {
            this.startForeground(8861, new Notification());
            Intent innerIntent = new Intent((Context)this, InnerService.class);
            this.startService(innerIntent);
        }
    }

    public static class InnerService
    extends Service {
        private static final String LOG_TAG_INNER = "Freeline.Service$Inner";

        public IBinder onBind(Intent intent) {
            return null;
        }

        public int onStartCommand(Intent intent, int flags, int startId) {
            Log.i((String)LOG_TAG_INNER, (String)("onStartCommand Received start id " + startId + ", intent: " + intent));
            try {
                this.startForeground(8861, new Notification());
                this.stopForeground(true);
                this.stopSelf();
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG_INNER, (String)"startForeground, stopForeground, stopSelf fail", (Throwable)e);
            }
            return super.onStartCommand(intent, flags, startId);
        }
    }
}

