/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.antfortune.freeline.FreelineCore;
import com.antfortune.freeline.util.ActivityManager;
import java.util.HashMap;

public class FreelineReceiver
extends BroadcastReceiver {
    private static final String TAG = "Freeline.Receiver";
    public static final String ACTION_KEY = "action";
    public static final String UUID = "uuid";
    public static final String SP_KEY = "sp_key";
    public static final String SP_VALUE = "sp_value";
    public static final String DEX_VALUE = "dex_path";
    public static final String OPT_VALUE = "opt_path";
    public static final int ACTION_UPDATE_ACTIVITY = 1;
    public static final int ACTION_RESTART_APPLICATION = 2;
    public static final int ACTION_SAVE_DYNAMIC_INFO = 3;

    public void onReceive(Context context, Intent intent) {
        String uuid = intent.getStringExtra(UUID);
        if (FreelineCore.getUuid().equalsIgnoreCase(uuid)) {
            int type = intent.getIntExtra(ACTION_KEY, -1);
            Log.i((String)TAG, (String)("receive action type: " + type));
            if (type == 1) {
                this.saveDynamicResInfo(intent);
                FreelineCore.updateDynamicTime();
                ActivityManager.restartActivity();
            } else if (type == 2) {
                this.saveDynamicResInfo(intent);
                this.applyDynamicDex(intent);
                FreelineCore.updateDynamicTime();
                ActivityManager.restart((Context)FreelineCore.getApplication(), true);
            }
        }
    }

    private void saveDynamicResInfo(Intent intent) {
        String key = intent.getStringExtra(SP_KEY);
        String value = intent.getStringExtra(SP_VALUE);
        if (!TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)value)) {
            HashMap<String, String> res = new HashMap<String, String>();
            Log.d((String)TAG, (String)("destPath :" + value));
            res.put(key, value);
            FreelineCore.saveDynamicResInfo(res);
        }
    }

    private void applyDynamicDex(Intent intent) {
        String dex = intent.getStringExtra(DEX_VALUE);
        String opt = intent.getStringExtra(OPT_VALUE);
        if (!TextUtils.isEmpty((CharSequence)dex) && !TextUtils.isEmpty((CharSequence)opt)) {
            FreelineCore.applyDynamicDex(dex, opt);
        }
    }
}

