/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.antfortune.freeline.FreelineService;
import com.antfortune.freeline.IDynamic;
import com.antfortune.freeline.gradle.GradleDynamic;
import com.antfortune.freeline.util.ActivityManager;
import com.antfortune.freeline.util.AppUtils;
import com.antfortune.freeline.util.DexUtils;
import com.antfortune.freeline.util.FileUtils;
import com.antfortune.freeline.util.NativeUtils;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class FreelineCore {
    private static final String TAG = "Freeline";
    private static final String DYNAMIC_INFO_FILE_NAME = "FREELINE_DYNAMIC_INFO";
    private static final String SYNC_INFO_FILE_NAME = "FREELINE_SYNC_INFO";
    public static final String DEFAULT_PACKAGE_ID = "base-res.key";
    private static final String DYNAMIC_INFO_DEX_PATH_KEY = "dynamic_dex_key";
    private static final String DYNAMIC_INFO_OPT_PATH_KEY = "dynamic_opt_key";
    private static long sApkBuildFlag = 0L;
    private static Application sApplication;
    private static IDynamic sDynamic;

    public static void init(Application app) {
        FreelineCore.init(app, new GradleDynamic(app));
    }

    public static void init(Application app, IDynamic dynamicImpl) {
        Log.i((String)TAG, (String)"freeline start initial process...");
        sApplication = app;
        FreelineCore.setDynamicImpl(dynamicImpl);
        if (AppUtils.isApkDebugable((Context)app) && AppUtils.isMainProcess((Context)app)) {
            Log.i((String)TAG, (String)"freeline init application");
            ActivityManager.initApplication(app);
            try {
                Object mPackageInfo = FreelineCore.getPackageInfo(app);
                Field field = mPackageInfo.getClass().getDeclaredField("mClassLoader");
                field.setAccessible(true);
                PathClassLoader origin = (PathClassLoader)field.get(mPackageInfo);
                if (FreelineCore.checkVersionChange()) {
                    Log.i((String)TAG, (String)"the apk has recover, delete cache");
                    FreelineCore.clearDynamicCache();
                    FreelineCore.clearSyncCache();
                } else {
                    Log.i((String)TAG, (String)"start to inject dex...");
                    FreelineCore.injectDex(origin);
                    Log.i((String)TAG, (String)"start to inject resources...");
                    FreelineCore.injectResources();
                }
                Log.i((String)TAG, (String)"start to load hackload.dex...");
                FreelineCore.injectHackDex((Context)app, origin);
                Log.i((String)TAG, (String)"start to inject native lib...");
                FreelineCore.injectHackNativeLib((Context)app, origin);
            }
            catch (Exception e) {
                FreelineCore.printStackTrace(e);
            }
            Log.i((String)TAG, (String)"freeline init server");
            FreelineCore.startLongLinkServer();
        }
    }

    public static void setDynamicImpl(IDynamic dynamicImpl) {
        sDynamic = dynamicImpl;
    }

    private static void startLongLinkServer() {
        Intent intent = new Intent((Context)sApplication, FreelineService.class);
        sApplication.startService(intent);
    }

    private static String getDynamicDexPath() {
        return FreelineCore.getDynamicInfoSp().getString(DYNAMIC_INFO_DEX_PATH_KEY, null);
    }

    private static String getDynamicDexOptPath() {
        return FreelineCore.getDynamicInfoSp().getString(DYNAMIC_INFO_OPT_PATH_KEY, null);
    }

    public static void clearDynamicCache() {
        FreelineCore.getDynamicInfoSp().edit().clear().commit();
        FileUtils.rm(new File(FreelineCore.getDynamicInfoTempDir()));
        Log.i((String)TAG, (String)"clear dynamic info sp cache");
    }

    public static void clearSyncCache() {
        FreelineCore.getSyncInfoSp().edit().clear().commit();
        Log.i((String)TAG, (String)"clear sync info sp cache");
    }

    public static long getBuildTime(Context context) {
        String path = context.getApplicationContext().getPackageResourcePath();
        return new File(path).lastModified();
    }

    public static long getApkBuildFlag() {
        if (sApkBuildFlag == 0L) {
            try {
                InputStream is = sApplication.getAssets().open("apktime");
                int size = is.available();
                byte[] buffer = new byte[size];
                is.read(buffer);
                is.close();
                String text = new String(buffer, "GB2312");
                Log.i((String)TAG, (String)("ext:" + text));
                sApkBuildFlag = Long.parseLong(text);
            }
            catch (Exception e) {
                FreelineCore.printStackTrace(e);
            }
        }
        return sApkBuildFlag;
    }

    private static void copyAssets(Context context, String assetName, String strOutFileName) throws IOException {
        FileOutputStream myOutput = new FileOutputStream(strOutFileName);
        InputStream myInput = context.getAssets().open(assetName);
        byte[] buffer = new byte[1024];
        int length = myInput.read(buffer);
        while (length > 0) {
            ((OutputStream)myOutput).write(buffer, 0, length);
            length = myInput.read(buffer);
        }
        myOutput.flush();
        myInput.close();
        ((OutputStream)myOutput).close();
    }

    private static String getDynamicCacheDir() {
        File dir = new File(sApplication.getCacheDir(), "hack");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir.getAbsolutePath();
    }

    private static long getDynamicTime() {
        return FreelineCore.getDynamicInfoSp().getLong("dynamicTime", System.currentTimeMillis());
    }

    private static boolean checkVersionChange() {
        return FreelineCore.getBuildTime((Context)sApplication) > FreelineCore.getDynamicTime();
    }

    private static Object getPackageInfo(Application app) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Context contextImpl = app.getBaseContext();
        Field mPackageInfoField = contextImpl.getClass().getDeclaredField("mPackageInfo");
        mPackageInfoField.setAccessible(true);
        Object mPackageInfo = mPackageInfoField.get(contextImpl);
        return mPackageInfo;
    }

    private static void injectHackDex(Context context, PathClassLoader origin) {
        File hostDex = new File(FreelineCore.getDynamicCacheDir(), "hackload.dex");
        if (!hostDex.exists() || hostDex.length() < 100L) {
            try {
                FreelineCore.copyAssets(context, "hackload.dex", hostDex.getAbsolutePath());
                Log.i((String)TAG, (String)"copy hackload dex from assets success");
            }
            catch (Exception e) {
                FreelineCore.printStackTrace(e);
            }
        }
        if (hostDex.exists() && hostDex.length() > 100L) {
            File opt = new File(FreelineCore.getDynamicCacheDir(), "opt");
            if (!opt.exists()) {
                opt.mkdirs();
            }
            DexUtils.inject(origin, hostDex, opt);
            Log.i((String)TAG, (String)("load hackload\uff0cdex size:" + hostDex.length()));
        }
    }

    private static void injectHackNativeLib(Context context, PathClassLoader classLoader) {
        NativeUtils.injectHackNativeLib(FreelineCore.getDynamicNativeDir(), classLoader);
    }

    private static void injectDex(PathClassLoader origin) {
        File dex;
        String dexPath = FreelineCore.getDynamicDexPath();
        if (!TextUtils.isEmpty((CharSequence)dexPath) && (dex = new File(dexPath)).exists()) {
            File opt = new File(FreelineCore.getDynamicDexOptPath());
            if (!opt.exists()) {
                opt.mkdirs();
            }
            DexUtils.inject(origin, dex, opt);
            Log.i((String)TAG, (String)"find increment package");
        }
    }

    public static void injectResources() {
        Map map = FreelineCore.getDynamicInfoSp().getAll();
        Log.i((String)TAG, (String)("dynamicInfoSp: " + map.toString()));
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            if (!key.contains("-")) continue;
            resMap.put(key, (String)map.get(key));
        }
        Log.i((String)TAG, (String)("resMap: " + resMap.toString()));
        if (!resMap.isEmpty()) {
            FreelineCore.applyDynamicRes(resMap);
        }
    }

    public static boolean applyDynamicDex(String dexFileStr, String dexOptDir) {
        Log.i((String)TAG, (String)("apply dynamicDex " + dexFileStr));
        SharedPreferences sp = FreelineCore.getDynamicInfoSp();
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(DYNAMIC_INFO_DEX_PATH_KEY, dexFileStr);
        editor.putString(DYNAMIC_INFO_OPT_PATH_KEY, dexOptDir);
        editor.commit();
        return true;
    }

    public static void printStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        String resultStr = ((Object)result).toString();
        Log.e((String)TAG, (String)resultStr);
    }

    public static String getDynamicResPath(String packageId) {
        return FreelineCore.getDynamicInfoSp().getString(FreelineCore.getDynamicResPathKey(packageId), null);
    }

    private static String getDynamicResPathKey(String packageId) {
        return packageId + ".key";
    }

    public static long getLastDynamicSyncId() {
        return FreelineCore.getSyncInfoSp().getLong("lastSync", 0L);
    }

    public static void saveLastDynamicSyncId(long sync) {
        FreelineCore.getSyncInfoSp().edit().putLong("lastSync", sync).commit();
    }

    private static SharedPreferences getDynamicInfoSp() {
        return sApplication.getBaseContext().getSharedPreferences(DYNAMIC_INFO_FILE_NAME, 0);
    }

    private static SharedPreferences getSyncInfoSp() {
        return sApplication.getBaseContext().getSharedPreferences(SYNC_INFO_FILE_NAME, 0);
    }

    public static String getBundleFilePathByPackageId(String packageId) {
        if (sDynamic != null) {
            return sDynamic.getOriginResPath(packageId);
        }
        return null;
    }

    private static boolean applyDynamicRes(HashMap<String, String> dynamicRes) {
        if (sDynamic != null) {
            return sDynamic.applyDynamicRes(dynamicRes);
        }
        return false;
    }

    public static void updateDynamicTime() {
        long dynamicTime = System.currentTimeMillis();
        Log.i((String)TAG, (String)("update dynamic time: " + dynamicTime));
        FreelineCore.getDynamicInfoSp().edit().putLong("dynamicTime", dynamicTime).commit();
    }

    public static boolean saveDynamicResInfo(HashMap<String, String> dynamicRes) {
        boolean result = true;
        SharedPreferences sp = FreelineCore.getDynamicInfoSp();
        SharedPreferences.Editor editor = sp.edit();
        for (String packageId : dynamicRes.keySet()) {
            String pendingPath = dynamicRes.get(packageId);
            editor.putString(FreelineCore.getDynamicResPathKey(packageId), pendingPath);
        }
        editor.commit();
        Log.i((String)TAG, (String)("apply res :" + dynamicRes));
        FreelineCore.injectResources();
        return result;
    }

    public static String getDynamicInfoTempDir() {
        File dir = new File(sApplication.getCacheDir(), "temp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir.getAbsolutePath();
    }

    public static String getDynamicNativeDir() {
        File dir = new File(FreelineCore.getDynamicInfoTempDir(), "native");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir.getAbsolutePath();
    }

    public static String getDynamicInfoTempPath(String packageId) {
        File dir = Build.VERSION.SDK_INT < 21 ? new File(FreelineCore.getDynamicInfoTempDir(), packageId + ".jar") : new File(FreelineCore.getDynamicInfoTempDir(), packageId);
        return dir.getAbsolutePath();
    }

    public static String getUuid() {
        return String.valueOf(FreelineCore.getApkBuildFlag());
    }

    private static String generateStringMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(input.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(Integer.toHexString(aByte & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)"MD5 algorithm not found.");
            return input;
        }
    }

    public static void clearResourcesCache() {
        if (sDynamic != null) {
            sDynamic.clearResourcesCache();
        }
    }

    public static Application getApplication() {
        return sApplication;
    }

    public static void updateActivity(String bundleName, String path) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.FreelineReceiver");
        intent.putExtra("uuid", FreelineCore.getUuid());
        intent.putExtra("action", 1);
        intent.putExtra("sp_key", bundleName);
        intent.putExtra("sp_value", path);
        sApplication.sendBroadcast(intent);
    }

    public static void restartApplication(String bundleName, String path, String dexPath, String dirPath) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.FreelineReceiver");
        intent.putExtra("uuid", FreelineCore.getUuid());
        intent.putExtra("action", 2);
        intent.putExtra("sp_key", bundleName);
        intent.putExtra("sp_value", path);
        intent.putExtra("dex_path", dexPath);
        intent.putExtra("opt_path", dirPath);
        sApplication.sendBroadcast(intent);
    }

    @Deprecated
    public static void saveDynamicInfo(String bundleName, String path) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.FreelineReceiver");
        intent.putExtra("uuid", FreelineCore.getUuid());
        intent.putExtra("action", 3);
        intent.putExtra("sp_key", bundleName);
        intent.putExtra("sp_value", path);
        sApplication.sendBroadcast(intent);
    }
}

