/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.CacheEncodeException;
import com.alicp.jetcache.support.DecoderMap;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractValueDecoder
implements Function<byte[], Object> {
    protected boolean useIdentityNumber;

    public AbstractValueDecoder(boolean useIdentityNumber) {
        this.useIdentityNumber = useIdentityNumber;
    }

    protected int parseHeader(byte[] buf) {
        int x = 0;
        x |= buf[0] & 0xFF;
        x <<= 8;
        x |= buf[1] & 0xFF;
        x <<= 8;
        x |= buf[2] & 0xFF;
        x <<= 8;
        return x |= buf[3] & 0xFF;
    }

    protected abstract Object doApply(byte[] var1) throws Exception;

    @Override
    public Object apply(byte[] buffer) {
        try {
            if (this.useIdentityNumber) {
                DecoderMap.registerBuildInDecoder();
                int identityNumber = this.parseHeader(buffer);
                AbstractValueDecoder decoder = DecoderMap.getDecoder(identityNumber);
                Objects.requireNonNull(decoder, "no decoder for identity number:" + identityNumber);
                return decoder.doApply(buffer);
            }
            return this.doApply(buffer);
        }
        catch (Exception e) {
            throw new CacheEncodeException("decode error", e);
        }
    }

    public boolean isUseIdentityNumber() {
        return this.useIdentityNumber;
    }
}

