/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.csv;

import com.alibaba.excel.constant.BuiltinFormats;
import com.alibaba.excel.enums.ByteOrderMarkEnum;
import com.alibaba.excel.enums.NumericCellTypeEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.csv.CsvCell;
import com.alibaba.excel.metadata.csv.CsvRow;
import com.alibaba.excel.metadata.csv.CsvWorkbook;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.util.NumberDataFormatterUtils;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.PaneType;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;

public class CsvSheet
implements Sheet,
Closeable {
    private CsvWorkbook csvWorkbook;
    private Appendable out;
    private Integer rowCacheCount;
    public CSVFormat csvFormat;
    private Integer lastRowIndex;
    private List<CsvRow> rowCache;
    private CSVPrinter csvPrinter;

    public CsvSheet(CsvWorkbook csvWorkbook, Appendable out) {
        this.csvWorkbook = csvWorkbook;
        this.out = out;
        this.rowCacheCount = 100;
        this.csvFormat = CSVFormat.DEFAULT;
        this.lastRowIndex = -1;
    }

    public Row createRow(int rownum) {
        this.initSheet();
        Integer n = this.lastRowIndex;
        Integer n2 = this.lastRowIndex = Integer.valueOf(this.lastRowIndex + 1);
        assert (rownum == this.lastRowIndex) : "csv create row must be in order.";
        this.printData();
        CsvRow csvRow = new CsvRow(this.csvWorkbook, this, rownum);
        this.rowCache.add(csvRow);
        return csvRow;
    }

    private void initSheet() {
        if (this.csvPrinter != null) {
            return;
        }
        this.rowCache = ListUtils.newArrayListWithExpectedSize(this.rowCacheCount);
        try {
            ByteOrderMarkEnum byteOrderMark;
            if (this.csvWorkbook.getWithBom().booleanValue() && (byteOrderMark = ByteOrderMarkEnum.valueOfByCharsetName(this.csvWorkbook.getCharset().name())) != null) {
                this.out.append(byteOrderMark.getStringPrefix());
            }
            this.csvPrinter = this.csvFormat.print(this.out);
        }
        catch (IOException e) {
            throw new ExcelGenerateException(e);
        }
    }

    public void removeRow(Row row) {
        throw new UnsupportedOperationException("csv cannot move row.");
    }

    public Row getRow(int rownum) {
        int actualRowIndex = rownum - (this.lastRowIndex - this.rowCache.size()) - 1;
        if (actualRowIndex < 0 || actualRowIndex > this.rowCache.size() - 1) {
            throw new UnsupportedOperationException("The current data does not exist or has been flushed to disk\n.");
        }
        return this.rowCache.get(actualRowIndex);
    }

    public int getPhysicalNumberOfRows() {
        return this.lastRowIndex - this.rowCache.size();
    }

    public int getFirstRowNum() {
        if (this.lastRowIndex < 0) {
            return -1;
        }
        return 0;
    }

    public int getLastRowNum() {
        return this.lastRowIndex;
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
    }

    public boolean isColumnHidden(int columnIndex) {
        return false;
    }

    public void setRightToLeft(boolean value) {
    }

    public boolean isRightToLeft() {
        return false;
    }

    public void setColumnWidth(int columnIndex, int width) {
    }

    public int getColumnWidth(int columnIndex) {
        return 0;
    }

    public float getColumnWidthInPixels(int columnIndex) {
        return 0.0f;
    }

    public void setDefaultColumnWidth(int width) {
    }

    public int getDefaultColumnWidth() {
        return 0;
    }

    public short getDefaultRowHeight() {
        return 0;
    }

    public float getDefaultRowHeightInPoints() {
        return 0.0f;
    }

    public void setDefaultRowHeight(short height) {
    }

    public void setDefaultRowHeightInPoints(float height) {
    }

    public CellStyle getColumnStyle(int column) {
        return null;
    }

    public int addMergedRegion(CellRangeAddress region) {
        return 0;
    }

    public int addMergedRegionUnsafe(CellRangeAddress region) {
        return 0;
    }

    public void validateMergedRegions() {
    }

    public void setVerticallyCenter(boolean value) {
    }

    public void setHorizontallyCenter(boolean value) {
    }

    public boolean getHorizontallyCenter() {
        return false;
    }

    public boolean getVerticallyCenter() {
        return false;
    }

    public void removeMergedRegion(int index) {
    }

    public void removeMergedRegions(Collection<Integer> indices) {
    }

    public int getNumMergedRegions() {
        return 0;
    }

    public CellRangeAddress getMergedRegion(int index) {
        return null;
    }

    public List<CellRangeAddress> getMergedRegions() {
        return null;
    }

    public Iterator<Row> rowIterator() {
        return this.rowCache.iterator();
    }

    public void setForceFormulaRecalculation(boolean value) {
    }

    public boolean getForceFormulaRecalculation() {
        return false;
    }

    public void setAutobreaks(boolean value) {
    }

    public void setDisplayGuts(boolean value) {
    }

    public void setDisplayZeros(boolean value) {
    }

    public boolean isDisplayZeros() {
        return false;
    }

    public void setFitToPage(boolean value) {
    }

    public void setRowSumsBelow(boolean value) {
    }

    public void setRowSumsRight(boolean value) {
    }

    public boolean getAutobreaks() {
        return false;
    }

    public boolean getDisplayGuts() {
        return false;
    }

    public boolean getFitToPage() {
        return false;
    }

    public boolean getRowSumsBelow() {
        return false;
    }

    public boolean getRowSumsRight() {
        return false;
    }

    public boolean isPrintGridlines() {
        return false;
    }

    public void setPrintGridlines(boolean show) {
    }

    public boolean isPrintRowAndColumnHeadings() {
        return false;
    }

    public void setPrintRowAndColumnHeadings(boolean show) {
    }

    public PrintSetup getPrintSetup() {
        return null;
    }

    public Header getHeader() {
        return null;
    }

    public Footer getFooter() {
        return null;
    }

    public void setSelected(boolean value) {
    }

    public double getMargin(short margin) {
        return 0.0;
    }

    public double getMargin(PageMargin pageMargin) {
        return 0.0;
    }

    public void setMargin(short margin, double size) {
    }

    public void setMargin(PageMargin pageMargin, double v) {
    }

    public boolean getProtect() {
        return false;
    }

    public void protectSheet(String password) {
    }

    public boolean getScenarioProtect() {
        return false;
    }

    public void setZoom(int scale) {
    }

    public short getTopRow() {
        return 0;
    }

    public short getLeftCol() {
        return 0;
    }

    public void showInPane(int topRow, int leftCol) {
    }

    public void shiftRows(int startRow, int endRow, int n) {
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
    }

    public void shiftColumns(int startColumn, int endColumn, int n) {
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
    }

    public void createFreezePane(int colSplit, int rowSplit) {
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
    }

    public void createSplitPane(int i, int i1, int i2, int i3, PaneType paneType) {
    }

    public PaneInformation getPaneInformation() {
        return null;
    }

    public void setDisplayGridlines(boolean show) {
    }

    public boolean isDisplayGridlines() {
        return false;
    }

    public void setDisplayFormulas(boolean show) {
    }

    public boolean isDisplayFormulas() {
        return false;
    }

    public void setDisplayRowColHeadings(boolean show) {
    }

    public boolean isDisplayRowColHeadings() {
        return false;
    }

    public void setRowBreak(int row) {
    }

    public boolean isRowBroken(int row) {
        return false;
    }

    public void removeRowBreak(int row) {
    }

    public int[] getRowBreaks() {
        return new int[0];
    }

    public int[] getColumnBreaks() {
        return new int[0];
    }

    public void setColumnBreak(int column) {
    }

    public boolean isColumnBroken(int column) {
        return false;
    }

    public void removeColumnBreak(int column) {
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
    }

    public void groupColumn(int fromColumn, int toColumn) {
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
    }

    public void groupRow(int fromRow, int toRow) {
    }

    public void ungroupRow(int fromRow, int toRow) {
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
    }

    public void autoSizeColumn(int column) {
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
    }

    public Comment getCellComment(CellAddress ref) {
        return null;
    }

    public Map<CellAddress, ? extends Comment> getCellComments() {
        return null;
    }

    public Drawing<?> getDrawingPatriarch() {
        return null;
    }

    public Drawing<?> createDrawingPatriarch() {
        return null;
    }

    public Workbook getWorkbook() {
        return this.csvWorkbook;
    }

    public String getSheetName() {
        return null;
    }

    public boolean isSelected() {
        return false;
    }

    public CellRange<? extends Cell> setArrayFormula(String formula, CellRangeAddress range) {
        return null;
    }

    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        return null;
    }

    public DataValidationHelper getDataValidationHelper() {
        return null;
    }

    public List<? extends DataValidation> getDataValidations() {
        return null;
    }

    public void addValidationData(DataValidation dataValidation) {
    }

    public AutoFilter setAutoFilter(CellRangeAddress range) {
        return null;
    }

    public SheetConditionalFormatting getSheetConditionalFormatting() {
        return null;
    }

    public CellRangeAddress getRepeatingRows() {
        return null;
    }

    public CellRangeAddress getRepeatingColumns() {
        return null;
    }

    public void setRepeatingRows(CellRangeAddress rowRangeRef) {
    }

    public void setRepeatingColumns(CellRangeAddress columnRangeRef) {
    }

    public int getColumnOutlineLevel(int columnIndex) {
        return 0;
    }

    public Hyperlink getHyperlink(int row, int column) {
        return null;
    }

    public Hyperlink getHyperlink(CellAddress addr) {
        return null;
    }

    public List<? extends Hyperlink> getHyperlinkList() {
        return null;
    }

    public CellAddress getActiveCell() {
        return null;
    }

    public void setActiveCell(CellAddress address) {
    }

    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    @Override
    public void close() throws IOException {
        this.initSheet();
        this.flushData();
        this.csvPrinter.flush();
        this.csvPrinter.close();
    }

    public void printData() {
        if (this.rowCache.size() >= this.rowCacheCount) {
            this.flushData();
        }
    }

    public void flushData() {
        try {
            for (CsvRow row : this.rowCache) {
                Iterator<Cell> cellIterator = row.cellIterator();
                int columnIndex = 0;
                while (cellIterator.hasNext()) {
                    CsvCell csvCell = (CsvCell)cellIterator.next();
                    while (csvCell.getColumnIndex() > columnIndex++) {
                        this.csvPrinter.print(null);
                    }
                    this.csvPrinter.print((Object)this.buildCellValue(csvCell));
                }
                this.csvPrinter.println();
            }
            this.rowCache.clear();
        }
        catch (IOException e) {
            throw new ExcelGenerateException(e);
        }
    }

    private String buildCellValue(CsvCell csvCell) {
        switch (csvCell.getCellType()) {
            case STRING: 
            case ERROR: {
                return csvCell.getStringCellValue();
            }
            case NUMERIC: {
                Short dataFormat = null;
                String dataFormatString = null;
                if (csvCell.getCellStyle() != null) {
                    dataFormat = csvCell.getCellStyle().getDataFormat();
                    dataFormatString = csvCell.getCellStyle().getDataFormatString();
                }
                if (csvCell.getNumericCellType() == NumericCellTypeEnum.DATE) {
                    if (csvCell.getDateValue() == null) {
                        return null;
                    }
                    if (dataFormat == null) {
                        dataFormatString = DateUtils.defaultDateFormat;
                        dataFormat = this.csvWorkbook.createDataFormat().getFormat(dataFormatString);
                    }
                    if (dataFormatString == null) {
                        dataFormatString = this.csvWorkbook.createDataFormat().getFormat(dataFormat.shortValue());
                    }
                    return NumberDataFormatterUtils.format(BigDecimal.valueOf(DateUtil.getExcelDate((LocalDateTime)csvCell.getDateValue(), (boolean)this.csvWorkbook.getUse1904windowing())), dataFormat, dataFormatString, this.csvWorkbook.getUse1904windowing(), this.csvWorkbook.getLocale(), this.csvWorkbook.getUseScientificFormat());
                }
                if (csvCell.getNumberValue() == null) {
                    return null;
                }
                if (dataFormat == null) {
                    dataFormat = BuiltinFormats.GENERAL;
                    dataFormatString = this.csvWorkbook.createDataFormat().getFormat(dataFormat.shortValue());
                }
                if (dataFormatString == null) {
                    dataFormatString = this.csvWorkbook.createDataFormat().getFormat(dataFormat.shortValue());
                }
                return NumberDataFormatterUtils.format(csvCell.getNumberValue(), dataFormat, dataFormatString, this.csvWorkbook.getUse1904windowing(), this.csvWorkbook.getLocale(), this.csvWorkbook.getUseScientificFormat());
            }
            case BOOLEAN: {
                return csvCell.getBooleanValue().toString();
            }
            case BLANK: {
                return "";
            }
        }
        return null;
    }

    public CsvWorkbook getCsvWorkbook() {
        return this.csvWorkbook;
    }

    public Appendable getOut() {
        return this.out;
    }

    public Integer getRowCacheCount() {
        return this.rowCacheCount;
    }

    public CSVFormat getCsvFormat() {
        return this.csvFormat;
    }

    public Integer getLastRowIndex() {
        return this.lastRowIndex;
    }

    public List<CsvRow> getRowCache() {
        return this.rowCache;
    }

    public CSVPrinter getCsvPrinter() {
        return this.csvPrinter;
    }

    public void setCsvWorkbook(CsvWorkbook csvWorkbook) {
        this.csvWorkbook = csvWorkbook;
    }

    public void setOut(Appendable out) {
        this.out = out;
    }

    public void setRowCacheCount(Integer rowCacheCount) {
        this.rowCacheCount = rowCacheCount;
    }

    public void setCsvFormat(CSVFormat csvFormat) {
        this.csvFormat = csvFormat;
    }

    public void setLastRowIndex(Integer lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
    }

    public void setRowCache(List<CsvRow> rowCache) {
        this.rowCache = rowCache;
    }

    public void setCsvPrinter(CSVPrinter csvPrinter) {
        this.csvPrinter = csvPrinter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvSheet)) {
            return false;
        }
        CsvSheet other = (CsvSheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$rowCacheCount = this.getRowCacheCount();
        Integer other$rowCacheCount = other.getRowCacheCount();
        if (this$rowCacheCount == null ? other$rowCacheCount != null : !((Object)this$rowCacheCount).equals(other$rowCacheCount)) {
            return false;
        }
        Integer this$lastRowIndex = this.getLastRowIndex();
        Integer other$lastRowIndex = other.getLastRowIndex();
        if (this$lastRowIndex == null ? other$lastRowIndex != null : !((Object)this$lastRowIndex).equals(other$lastRowIndex)) {
            return false;
        }
        CsvWorkbook this$csvWorkbook = this.getCsvWorkbook();
        CsvWorkbook other$csvWorkbook = other.getCsvWorkbook();
        if (this$csvWorkbook == null ? other$csvWorkbook != null : !((Object)this$csvWorkbook).equals(other$csvWorkbook)) {
            return false;
        }
        Appendable this$out = this.getOut();
        Appendable other$out = other.getOut();
        if (this$out == null ? other$out != null : !this$out.equals(other$out)) {
            return false;
        }
        CSVFormat this$csvFormat = this.getCsvFormat();
        CSVFormat other$csvFormat = other.getCsvFormat();
        if (this$csvFormat == null ? other$csvFormat != null : !this$csvFormat.equals(other$csvFormat)) {
            return false;
        }
        List<CsvRow> this$rowCache = this.getRowCache();
        List<CsvRow> other$rowCache = other.getRowCache();
        if (this$rowCache == null ? other$rowCache != null : !((Object)this$rowCache).equals(other$rowCache)) {
            return false;
        }
        CSVPrinter this$csvPrinter = this.getCsvPrinter();
        CSVPrinter other$csvPrinter = other.getCsvPrinter();
        return !(this$csvPrinter == null ? other$csvPrinter != null : !this$csvPrinter.equals(other$csvPrinter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsvSheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $rowCacheCount = this.getRowCacheCount();
        result = result * 59 + ($rowCacheCount == null ? 43 : ((Object)$rowCacheCount).hashCode());
        Integer $lastRowIndex = this.getLastRowIndex();
        result = result * 59 + ($lastRowIndex == null ? 43 : ((Object)$lastRowIndex).hashCode());
        CsvWorkbook $csvWorkbook = this.getCsvWorkbook();
        result = result * 59 + ($csvWorkbook == null ? 43 : ((Object)$csvWorkbook).hashCode());
        Appendable $out = this.getOut();
        result = result * 59 + ($out == null ? 43 : $out.hashCode());
        CSVFormat $csvFormat = this.getCsvFormat();
        result = result * 59 + ($csvFormat == null ? 43 : $csvFormat.hashCode());
        List<CsvRow> $rowCache = this.getRowCache();
        result = result * 59 + ($rowCache == null ? 43 : ((Object)$rowCache).hashCode());
        CSVPrinter $csvPrinter = this.getCsvPrinter();
        result = result * 59 + ($csvPrinter == null ? 43 : $csvPrinter.hashCode());
        return result;
    }
}

