/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.util;

import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public final class TableDataProcessor {
    private static final String COLUMN_KEY_NAME = "\u540d\u79f0";
    private static final String COLUMN_VALUE_NAME = "\u503c";
    private static final String RESP_JSON_RESULT_KEY = "ResultCode";
    private static final String RESP_JSON_CONTENT_KEY = "Content";
    protected static final int RESP_SUCCESS_RESULT = 1;
    private static final Log LOG = LogFactory.getLog(TableDataProcessor.class);

    private TableDataProcessor() {
    }

    public static ColumnData row2col(ArrayList<LinkedHashMap<String, Object>> rowDatas, String keyword) {
        ColumnData datas = new ColumnData();
        ArrayList<LinkedHashMap<String, Object>> coldatas = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<String> colNames = new ArrayList<String>();
        int rowCount = 0;
        int colCount = 0;
        for (LinkedHashMap<String, Object> row : rowDatas) {
            if (keyword != null) {
                String keyNow = row.remove(keyword).toString();
                colNames.add(keyNow);
            }
            ++rowCount;
            for (Map.Entry<String, Object> element : row.entrySet()) {
                LinkedHashMap<String, Object> colData = new LinkedHashMap<String, Object>();
                colData.put(COLUMN_KEY_NAME, element.getKey());
                colData.put(COLUMN_VALUE_NAME, element.getValue());
                coldatas.add(colData);
                if (rowCount != 1) continue;
                ++colCount;
            }
        }
        datas.setCount(colCount);
        datas.setDatas(coldatas);
        datas.setNames(colNames);
        return datas;
    }

    public static ColumnData mutilRow2col(ArrayList<LinkedHashMap<String, Object>> rowDatas, String keyword) {
        ColumnData datas = new ColumnData();
        ArrayList<ArrayList<LinkedHashMap<String, Object>>> tableDatas = new ArrayList<ArrayList<LinkedHashMap<String, Object>>>();
        ArrayList<String> colNames = new ArrayList<String>();
        int rowCount = 0;
        for (LinkedHashMap<String, Object> row : rowDatas) {
            if (keyword != null) {
                String keyNow = row.remove(keyword).toString();
                colNames.add(keyNow);
            }
            ++rowCount;
            ArrayList coldatas = new ArrayList();
            for (Map.Entry<String, Object> element : row.entrySet()) {
                LinkedHashMap<String, Object> colData = new LinkedHashMap<String, Object>();
                colData.put(COLUMN_KEY_NAME, element.getKey());
                colData.put(COLUMN_VALUE_NAME, element.getValue());
                coldatas.add(colData);
            }
            tableDatas.add(coldatas);
        }
        datas.setCount(rowCount);
        datas.setTableDatas(tableDatas);
        datas.setNames(colNames);
        return datas;
    }

    public static ColumnData row2col(ArrayList<LinkedHashMap<String, Object>> rowDatas) {
        return TableDataProcessor.row2col(rowDatas, null);
    }

    public static ArrayList<LinkedHashMap<String, Object>> parseData(Object respData) {
        LinkedHashMap map;
        int rv;
        ArrayList<LinkedHashMap> data = null;
        if (respData instanceof Map && (rv = ((Integer)(map = (LinkedHashMap)respData).get(RESP_JSON_RESULT_KEY)).intValue()) == 1) {
            Object content = map.get(RESP_JSON_CONTENT_KEY);
            if (content instanceof List) {
                data = (ArrayList<LinkedHashMap>)content;
            } else if (content instanceof Map) {
                LinkedHashMap contentEle = (LinkedHashMap)content;
                data = new ArrayList<LinkedHashMap>();
                data.add(contentEle);
            }
        }
        return data;
    }

    public static Object getData(String url, MBeanServerConnection conn) throws Exception {
        Object o = null;
        ObjectName name = new ObjectName("com.alibaba.druid:type=DruidStatService");
        String result = (String)conn.invoke(name, "service", new String[]{url}, new String[]{String.class.getName()});
        o = JSONUtils.parse(result);
        if (LOG.isDebugEnabled()) {
            LOG.debug(o.toString());
        }
        return o;
    }

    public static class ColumnData {
        private ArrayList<String> names;
        private ArrayList<LinkedHashMap<String, Object>> datas;
        private ArrayList<ArrayList<LinkedHashMap<String, Object>>> tableDatas;
        private int count;

        public ArrayList<String> getNames() {
            return this.names;
        }

        public void setNames(ArrayList<String> names) {
            this.names = names;
        }

        public ArrayList<LinkedHashMap<String, Object>> getDatas() {
            return this.datas;
        }

        public void setDatas(ArrayList<LinkedHashMap<String, Object>> datas) {
            this.datas = datas;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public ArrayList<ArrayList<LinkedHashMap<String, Object>>> getTableDatas() {
            return this.tableDatas;
        }

        public void setTableDatas(ArrayList<ArrayList<LinkedHashMap<String, Object>>> tableDatas) {
            this.tableDatas = tableDatas;
        }
    }
}

