/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableConstaint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByHash;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByList;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByRange;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitioningClause;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitioningDef;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class MySqlCreateTableParser
extends SQLCreateTableParser {
    public MySqlCreateTableParser(String sql) {
        super(new MySqlExprParser(sql));
    }

    public MySqlCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCrateTable() {
        return this.parseCrateTable(true);
    }

    @Override
    public MySqlExprParser getExprParser() {
        return (MySqlExprParser)this.exprParser;
    }

    @Override
    public MySqlCreateTableStatement parseCrateTable(boolean acceptCreate) {
        SQLName name;
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        MySqlCreateTableStatement stmt = new MySqlCreateTableStatement();
        if (this.identifierEquals("TEMPORARY")) {
            this.lexer.nextToken();
            stmt.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            name = this.exprParser.name();
            stmt.setLike(name);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                name = this.exprParser.name();
                stmt.setLike(name);
            } else {
                while (true) {
                    SQLColumnDefinition column;
                    if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_CHARS) {
                        column = this.exprParser.parseColumn();
                        stmt.getTableElementList().add(column);
                    } else if (this.lexer.token() == Token.CONSTRAINT || this.lexer.token() == Token.PRIMARY || this.lexer.token() == Token.UNIQUE) {
                        stmt.getTableElementList().add(this.parseConstraint());
                    } else if (this.lexer.token() == Token.INDEX) {
                        this.lexer.nextToken();
                        MySqlTableIndex idx = new MySqlTableIndex();
                        if (this.lexer.token() == Token.IDENTIFIER && !"USING".equalsIgnoreCase(this.lexer.stringVal())) {
                            idx.setName(this.exprParser.name());
                        }
                        if (this.identifierEquals("USING")) {
                            this.lexer.nextToken();
                            idx.setIndexType(this.lexer.stringVal());
                            this.lexer.nextToken();
                        }
                        this.accept(Token.LPAREN);
                        while (true) {
                            idx.getColumns().add(this.exprParser.expr());
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                        stmt.getTableElementList().add(idx);
                    } else if (this.lexer.token() == Token.KEY) {
                        stmt.getTableElementList().add(this.parseConstraint());
                    } else if (this.lexer.token() == Token.PRIMARY) {
                        SQLTableConstaint pk = this.parseConstraint();
                        pk.setParent(stmt);
                        stmt.getTableElementList().add(pk);
                    } else if (this.lexer.token() == Token.FOREIGN) {
                        SQLForeignKeyConstraint fk = this.getExprParser().parseForeignKey();
                        fk.setParent(stmt);
                        stmt.getTableElementList().add(fk);
                    } else if (this.lexer.token() == Token.CHECK) {
                        SQLCheck check = this.exprParser.parseCheck();
                        stmt.getTableElementList().add(check);
                    } else {
                        column = this.exprParser.parseColumn();
                        stmt.getTableElementList().add(column);
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            this.accept(Token.RPAREN);
        }
        while (true) {
            if (this.identifierEquals("ENGINE")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("ENGINE", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("AUTO_INCREMENT")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("AUTO_INCREMENT", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("AVG_ROW_LENGTH")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("AVG_ROW_LENGTH", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                this.parseTableOptionCharsetOrCollate(stmt);
                continue;
            }
            if (this.parseTableOptionCharsetOrCollate(stmt)) continue;
            if (this.identifierEquals("CHECKSUM")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("CHECKSUM", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("COMMENT", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("CONNECTION")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("CONNECTION", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("DATA")) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("DATA DIRECTORY", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("DELAY_KEY_WRITE")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("DELAY_KEY_WRITE", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("INDEX")) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("INDEX DIRECTORY", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("INSERT_METHOD")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("INSERT_METHOD", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("KEY_BLOCK_SIZE")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("KEY_BLOCK_SIZE", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("MAX_ROWS")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("MAX_ROWS", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("MIN_ROWS")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("MIN_ROWS", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("PACK_KEYS")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("PACK_KEYS", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("PASSWORD")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("PASSWORD", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("ROW_FORMAT")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("ROW_FORMAT", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("STATS_AUTO_RECALC")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("STATS_AUTO_RECALC", this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("STATS_PERSISTENT")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("STATS_PERSISTENT", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                MySqlCreateTableStatement.TableSpaceOption option = new MySqlCreateTableStatement.TableSpaceOption();
                option.setName(this.exprParser.name());
                if (this.identifierEquals("STORAGE")) {
                    this.lexer.nextToken();
                    option.setStorage(this.exprParser.name());
                }
                stmt.getTableOptions().put("TABLESPACE", option);
                continue;
            }
            if (!this.identifierEquals("TYPE")) break;
            this.lexer.nextToken();
            this.accept(Token.EQ);
            stmt.getTableOptions().put("TYPE", this.exprParser.expr());
            this.lexer.nextToken();
        }
        if (this.identifierEquals("PARTITION")) {
            MySqlPartitioningClause partitionClause;
            MySqlPartitioningClause clause;
            this.lexer.nextToken();
            this.accept(Token.BY);
            boolean linera = false;
            if (this.identifierEquals("LINEAR")) {
                this.lexer.nextToken();
                linera = true;
            }
            if (this.lexer.token() == Token.KEY) {
                clause = new MySqlPartitionByKey();
                this.lexer.nextToken();
                if (linera) {
                    ((MySqlPartitionByKey)clause).setLinear(true);
                }
                this.accept(Token.LPAREN);
                while (true) {
                    ((MySqlPartitionByKey)clause).getColumns().add(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                partitionClause = clause;
                if (this.identifierEquals("PARTITIONS")) {
                    this.lexer.nextToken();
                    ((MySqlPartitionByKey)clause).setPartitionCount(this.exprParser.expr());
                }
            } else if (this.identifierEquals("HASH")) {
                this.lexer.nextToken();
                clause = new MySqlPartitionByHash();
                if (linera) {
                    ((MySqlPartitionByHash)clause).setLinear(true);
                }
                this.accept(Token.LPAREN);
                ((MySqlPartitionByHash)clause).setExpr(this.exprParser.expr());
                this.accept(Token.RPAREN);
                partitionClause = clause;
                if (this.identifierEquals("PARTITIONS")) {
                    this.lexer.nextToken();
                    ((MySqlPartitionByHash)clause).setPartitionCount(this.exprParser.expr());
                }
            } else if (this.identifierEquals("RANGE")) {
                this.lexer.nextToken();
                clause = new MySqlPartitionByRange();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    ((MySqlPartitionByRange)clause).setExpr(this.exprParser.expr());
                    this.accept(Token.RPAREN);
                } else {
                    this.acceptIdentifier("COLUMNS");
                    this.accept(Token.LPAREN);
                    while (true) {
                        ((MySqlPartitionByRange)clause).getColumns().add(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                partitionClause = clause;
                if (this.identifierEquals("PARTITIONS")) {
                    this.lexer.nextToken();
                    ((MySqlPartitionByRange)clause).setPartitionCount(this.exprParser.expr());
                }
            } else if (this.identifierEquals("LIST")) {
                this.lexer.nextToken();
                clause = new MySqlPartitionByList();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    ((MySqlPartitionByList)clause).setExpr(this.exprParser.expr());
                    this.accept(Token.RPAREN);
                } else {
                    this.acceptIdentifier("COLUMNS");
                    this.accept(Token.LPAREN);
                    while (true) {
                        ((MySqlPartitionByList)clause).getColumns().add(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                partitionClause = clause;
                if (this.identifierEquals("PARTITIONS")) {
                    this.lexer.nextToken();
                    ((MySqlPartitionByList)clause).setPartitionCount(this.exprParser.expr());
                }
            } else {
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    this.acceptIdentifier("PARTITION");
                    MySqlPartitioningDef partitionDef = new MySqlPartitioningDef();
                    partitionDef.setName(this.exprParser.name());
                    if (this.lexer.token() == Token.VALUES) {
                        MySqlPartitioningDef.Values values;
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.IN) {
                            this.lexer.nextToken();
                            values = new MySqlPartitioningDef.InValues();
                            this.accept(Token.LPAREN);
                            this.exprParser.exprList(values.getItems());
                            this.accept(Token.RPAREN);
                            partitionDef.setValues(values);
                        } else {
                            this.acceptIdentifier("LESS");
                            this.acceptIdentifier("THAN");
                            values = new MySqlPartitioningDef.LessThanValues();
                            this.accept(Token.LPAREN);
                            this.exprParser.exprList(values.getItems());
                            this.accept(Token.RPAREN);
                            partitionDef.setValues(values);
                        }
                    }
                    while (true) {
                        if (this.identifierEquals("DATA")) {
                            this.lexer.nextToken();
                            this.acceptIdentifier("DIRECTORY");
                            if (this.lexer.token() == Token.EQ) {
                                this.lexer.nextToken();
                            }
                            partitionDef.setDataDirectory(this.exprParser.expr());
                            continue;
                        }
                        if (this.lexer.token() != Token.INDEX) break;
                        this.lexer.nextToken();
                        this.acceptIdentifier("DIRECTORY");
                        if (this.lexer.token() == Token.EQ) {
                            this.lexer.nextToken();
                        }
                        partitionDef.setIndexDirectory(this.exprParser.expr());
                    }
                    partitionClause.getPartitions().add(partitionDef);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            stmt.setPartitioning(partitionClause);
        }
        if (this.lexer.token() == Token.ON) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SELECT) {
            SQLSelect query = new MySqlSelectParser(this.exprParser).select();
            stmt.setQuery(query);
        }
        return stmt;
    }

    private boolean parseTableOptionCharsetOrCollate(MySqlCreateTableStatement stmt) {
        if (this.identifierEquals("CHARACTER")) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.getTableOptions().put("CHARACTER SET", this.exprParser.expr());
            return true;
        }
        if (this.identifierEquals("CHARSET")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.getTableOptions().put("CHARSET", this.exprParser.expr());
            return true;
        }
        if (this.identifierEquals("COLLATE")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.getTableOptions().put("COLLATE", this.exprParser.expr());
            return true;
        }
        return false;
    }

    @Override
    protected SQLTableConstaint parseConstraint() {
        SQLName name = null;
        if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            name = this.exprParser.name();
        }
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            MySqlKey key = new MySqlKey();
            if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                key.setIndexType(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                name = this.exprParser.name();
            }
            this.accept(Token.LPAREN);
            while (true) {
                key.getColumns().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            if (name != null) {
                key.setName(name);
            }
            if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                key.setIndexType(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            return key;
        }
        if (this.lexer.token() == Token.PRIMARY) {
            SQLPrimaryKey pk = this.exprParser.parsePrimaryKey();
            pk.setName(name);
            return (SQLTableConstaint)((Object)pk);
        }
        if (this.lexer.token() == Token.UNIQUE) {
            MySqlUnique uk = this.getExprParser().parseUnique();
            uk.setName(name);
            return uk;
        }
        if (this.lexer.token() == Token.FOREIGN) {
            SQLForeignKeyConstraint fk = this.getExprParser().parseForeignKey();
            fk.setName(name);
            return fk;
        }
        throw new ParserException("TODO :" + (Object)((Object)this.lexer.token()));
    }
}

