/*
 * Decompiled with CFR 0.152.
 */
package com.a.eye.datacarrier.consumer;

import com.a.eye.datacarrier.buffer.Buffer;
import com.a.eye.datacarrier.consumer.IConsumer;
import java.util.LinkedList;
import java.util.List;

public class ConsumerThread<T>
extends Thread {
    private volatile boolean running;
    private IConsumer<T> consumer;
    private List<DataSource> dataSources;

    ConsumerThread(String threadName, IConsumer<T> consumer) {
        super(threadName);
        this.consumer = consumer;
        this.running = false;
        this.dataSources = new LinkedList<DataSource>();
    }

    void addDataSource(Buffer<T> sourceBuffer, int start, int end) {
        this.dataSources.add(new DataSource(sourceBuffer, start, end));
    }

    void addDataSource(Buffer<T> sourceBuffer) {
        this.dataSources.add(new DataSource(sourceBuffer, 0, sourceBuffer.getBufferSize()));
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            boolean hasData = false;
            for (DataSource dataSource : this.dataSources) {
                List data = dataSource.obtain();
                if (data.size() == 0) continue;
                hasData = true;
                try {
                    this.consumer.consume(data);
                }
                catch (Throwable t) {
                    this.consumer.onError(data, t);
                }
            }
            if (hasData) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void shutdown() {
        this.running = false;
    }

    class DataSource {
        private Buffer<T> sourceBuffer;
        private int start;
        private int end;

        DataSource(Buffer<T> sourceBuffer, int start, int end) {
            this.sourceBuffer = sourceBuffer;
            this.start = start;
            this.end = end;
        }

        List<T> obtain() {
            return this.sourceBuffer.obtain(this.start, this.end);
        }
    }
}

