/*
 * Decompiled with CFR 0.152.
 */
package com.a.eye.datacarrier.common;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicRangeInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = -4099792402691141643L;
    private AtomicInteger value;
    private int startValue;
    private int endValue;

    public AtomicRangeInteger(int startValue, int maxValue) {
        this.value = new AtomicInteger(startValue);
        this.startValue = startValue;
        this.endValue = maxValue - 1;
    }

    public final int getAndIncrement() {
        int next;
        int current;
        while (!this.value.compareAndSet(current, next = (current = this.value.get()) >= this.endValue ? this.startValue : current + 1)) {
        }
        return current;
    }

    public final int get() {
        return this.value.get();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }
}

