/*
 * Decompiled with CFR 0.152.
 */
package com.a.eye.datacarrier.buffer;

import com.a.eye.datacarrier.buffer.Buffer;
import com.a.eye.datacarrier.buffer.BufferStrategy;
import com.a.eye.datacarrier.partition.IDataPartitioner;

public class Channels<T> {
    private final Buffer<T>[] bufferChannels;
    private IDataPartitioner<T> dataPartitioner;

    public Channels(int channelSize, int bufferSize, IDataPartitioner<T> partitioner, BufferStrategy strategy) {
        this.dataPartitioner = partitioner;
        this.bufferChannels = new Buffer[channelSize];
        for (int i = 0; i < channelSize; ++i) {
            this.bufferChannels[i] = new Buffer(bufferSize, strategy);
        }
    }

    public boolean save(T data) {
        int index = this.dataPartitioner.partition(this.bufferChannels.length, data);
        return this.bufferChannels[index].save(data);
    }

    public void setPartitioner(IDataPartitioner<T> dataPartitioner) {
        this.dataPartitioner = dataPartitioner;
    }

    public void setStrategy(BufferStrategy strategy) {
        for (Buffer<T> buffer : this.bufferChannels) {
            buffer.setStrategy(strategy);
        }
    }

    public int getChannelSize() {
        return this.bufferChannels.length;
    }

    public Buffer<T> getBuffer(int index) {
        return this.bufferChannels[index];
    }
}

