/*
 * Decompiled with CFR 0.152.
 */
package com.a.eye.datacarrier.buffer;

import com.a.eye.datacarrier.buffer.BufferStrategy;
import com.a.eye.datacarrier.common.AtomicRangeInteger;
import java.util.ArrayList;
import java.util.List;

public class Buffer<T> {
    private final Object[] buffer;
    private BufferStrategy strategy;
    private AtomicRangeInteger index;

    Buffer(int bufferSize, BufferStrategy strategy) {
        this.buffer = new Object[bufferSize];
        this.strategy = strategy;
        this.index = new AtomicRangeInteger(0, bufferSize);
    }

    void setStrategy(BufferStrategy strategy) {
        this.strategy = strategy;
    }

    boolean save(T data) {
        int i = this.index.getAndIncrement();
        if (this.buffer[i] != null) {
            switch (this.strategy) {
                case BLOCKING: {
                    while (this.buffer[i] != null) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
                case IF_POSSIBLE: {
                    return false;
                }
            }
        }
        this.buffer[i] = data;
        return true;
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public List<T> obtain(int start, int end) {
        ArrayList<Object> result = new ArrayList<Object>(end - start);
        for (int i = start; i < end; ++i) {
            if (this.buffer[i] == null) continue;
            result.add(this.buffer[i]);
            this.buffer[i] = null;
        }
        return result;
    }
}

