/*
 * Decompiled with CFR 0.152.
 */
package com.a.eye.datacarrier;

import com.a.eye.datacarrier.buffer.BufferStrategy;
import com.a.eye.datacarrier.buffer.Channels;
import com.a.eye.datacarrier.consumer.ConsumerPool;
import com.a.eye.datacarrier.consumer.IConsumer;
import com.a.eye.datacarrier.partition.IDataPartitioner;
import com.a.eye.datacarrier.partition.SimpleRollingPartitioner;

public class DataCarrier<T> {
    private final int bufferSize;
    private final int channelSize;
    private Channels<T> channels;
    private ConsumerPool<T> consumerPool;

    public DataCarrier(int channelSize, int bufferSize) {
        this.bufferSize = bufferSize;
        this.channelSize = channelSize;
        this.channels = new Channels(channelSize, bufferSize, new SimpleRollingPartitioner(), BufferStrategy.BLOCKING);
    }

    public DataCarrier setPartitioner(IDataPartitioner<T> dataPartitioner) {
        this.channels.setPartitioner(dataPartitioner);
        return this;
    }

    public DataCarrier setBufferStrategy(BufferStrategy strategy) {
        this.channels.setStrategy(strategy);
        return this;
    }

    public boolean produce(T data) {
        if (this.consumerPool != null) {
            this.consumerPool.begin();
        }
        return this.channels.save(data);
    }

    public DataCarrier consume(IConsumer<T> prototype, int num, boolean usePrototypeCopies) {
        if (this.consumerPool != null) {
            this.consumerPool.close();
        }
        this.consumerPool = new ConsumerPool<T>(this.channels, prototype, num, usePrototypeCopies);
        this.consumerPool.begin();
        return this;
    }

    public void shutdownConsumers() {
        if (this.consumerPool != null) {
            this.consumerPool.close();
        }
    }
}

