/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.shutdown.PutNodeResponse;
import co.elastic.clients.elasticsearch.shutdown.Type;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutNodeRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String allocationDelay;
    @Nullable
    private final TimeUnit masterTimeout;
    private final String nodeId;
    private final String reason;
    @Nullable
    private final String targetNodeName;
    @Nullable
    private final TimeUnit timeout;
    private final Type type;
    public static final JsonpDeserializer<PutNodeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutNodeRequest::setupPutNodeRequestDeserializer);
    public static final Endpoint<PutNodeRequest, PutNodeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutNodeRequest, PutNodeResponse>("es/shutdown.put_node", request -> "PUT", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId, buf);
            buf.append("/shutdown");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout.jsonValue());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutNodeResponse._DESERIALIZER);

    private PutNodeRequest(Builder builder) {
        this.allocationDelay = builder.allocationDelay;
        this.masterTimeout = builder.masterTimeout;
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.targetNodeName = builder.targetNodeName;
        this.timeout = builder.timeout;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static PutNodeRequest of(Function<Builder, ObjectBuilder<PutNodeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String allocationDelay() {
        return this.allocationDelay;
    }

    @Nullable
    public final TimeUnit masterTimeout() {
        return this.masterTimeout;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String reason() {
        return this.reason;
    }

    @Nullable
    public final String targetNodeName() {
        return this.targetNodeName;
    }

    @Nullable
    public final TimeUnit timeout() {
        return this.timeout;
    }

    public final Type type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allocationDelay != null) {
            generator.writeKey("allocation_delay");
            generator.write(this.allocationDelay);
        }
        generator.writeKey("reason");
        generator.write(this.reason);
        if (this.targetNodeName != null) {
            generator.writeKey("target_node_name");
            generator.write(this.targetNodeName);
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    protected static void setupPutNodeRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocationDelay, JsonpDeserializer.stringDeserializer(), "allocation_delay");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::targetNodeName, JsonpDeserializer.stringDeserializer(), "target_node_name");
        op.add(Builder::type, Type._DESERIALIZER, "type");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutNodeRequest> {
        @Nullable
        private String allocationDelay;
        @Nullable
        private TimeUnit masterTimeout;
        private String nodeId;
        private String reason;
        @Nullable
        private String targetNodeName;
        @Nullable
        private TimeUnit timeout;
        private Type type;

        public final Builder allocationDelay(@Nullable String value) {
            this.allocationDelay = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable TimeUnit value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder targetNodeName(@Nullable String value) {
            this.targetNodeName = value;
            return this;
        }

        public final Builder timeout(@Nullable TimeUnit value) {
            this.timeout = value;
            return this;
        }

        public final Builder type(Type value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutNodeRequest build() {
            this._checkSingleUse();
            return new PutNodeRequest(this);
        }
    }
}

