/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.PutPrivilegesResponse;
import co.elastic.clients.elasticsearch.security.put_privileges.Actions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutPrivilegesRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Refresh refresh;
    private final Map<String, Map<String, Actions>> privileges;
    public static final JsonpDeserializer<PutPrivilegesRequest> _DESERIALIZER = PutPrivilegesRequest.createPutPrivilegesRequestDeserializer();
    public static final Endpoint<PutPrivilegesRequest, PutPrivilegesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutPrivilegesRequest, PutPrivilegesResponse>("es/security.put_privileges", request -> "PUT", request -> "/_security/privilege", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutPrivilegesResponse._DESERIALIZER);

    private PutPrivilegesRequest(Builder builder) {
        this.refresh = builder.refresh;
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
    }

    public static PutPrivilegesRequest of(Function<Builder, ObjectBuilder<PutPrivilegesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final Map<String, Map<String, Actions>> privileges() {
        return this.privileges;
    }

    @Nullable
    public final Map<String, Actions> get(String key) {
        return this.privileges.get(key);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        for (Map.Entry<String, Map<String, Actions>> item0 : this.privileges.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartObject();
            if (item0.getValue() != null) {
                for (Map.Entry<String, Actions> item1 : item0.getValue().entrySet()) {
                    generator.writeKey(item1.getKey());
                    item1.getValue().serialize(generator, mapper);
                }
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<PutPrivilegesRequest> createPutPrivilegesRequestDeserializer() {
        JsonpDeserializer<Map<String, Map<String, Actions>>> valueDeserializer = JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(Actions._DESERIALIZER));
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().privileges((Map)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutPrivilegesRequest> {
        @Nullable
        private Refresh refresh;
        private Map<String, Map<String, Actions>> privileges = new HashMap<String, Map<String, Actions>>();

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder privileges(Map<String, Map<String, Actions>> map) {
            this.privileges = Builder._mapPutAll(this.privileges, map);
            return this;
        }

        public final Builder privileges(String key, Map<String, Actions> value) {
            this.privileges = Builder._mapPut(this.privileges, key, value);
            return this;
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Map<String, Map<String, Actions>> value = JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(Actions._DESERIALIZER)).deserialize(parser, mapper);
            return this.privileges(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutPrivilegesRequest build() {
            this._checkSingleUse();
            return new PutPrivilegesRequest(this);
        }
    }
}

