/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch.core.health_report.Indicators;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class HealthReportResponse
implements JsonpSerializable {
    private final String clusterName;
    private final Indicators indicators;
    public static final JsonpDeserializer<HealthReportResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HealthReportResponse::setupHealthReportResponseDeserializer);

    private HealthReportResponse(Builder builder) {
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.indicators = ApiTypeHelper.requireNonNull(builder.indicators, this, "indicators");
    }

    public static HealthReportResponse of(Function<Builder, ObjectBuilder<HealthReportResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Indicators indicators() {
        return this.indicators;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("indicators");
        this.indicators.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHealthReportResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::indicators, Indicators._DESERIALIZER, "indicators");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HealthReportResponse> {
        private String clusterName;
        private Indicators indicators;

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder indicators(Indicators value) {
            this.indicators = value;
            return this;
        }

        public final Builder indicators(Function<Indicators.Builder, ObjectBuilder<Indicators>> fn) {
            return this.indicators(fn.apply(new Indicators.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HealthReportResponse build() {
            this._checkSingleUse();
            return new HealthReportResponse(this);
        }
    }
}

