/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatDatafeedColumn;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlDatafeedsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MlDatafeedsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final String datafeedId;
    private final List<CatDatafeedColumn> h;
    private final List<CatDatafeedColumn> s;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<MlDatafeedsRequest, MlDatafeedsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlDatafeedsRequest, MlDatafeedsResponse>("es/cat.ml_datafeeds", request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlDatafeedsResponse._DESERIALIZER);

    private MlDatafeedsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.datafeedId = builder.datafeedId;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
    }

    public static MlDatafeedsRequest of(Function<Builder, ObjectBuilder<MlDatafeedsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final String datafeedId() {
        return this.datafeedId;
    }

    public final List<CatDatafeedColumn> h() {
        return this.h;
    }

    public final List<CatDatafeedColumn> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MlDatafeedsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private String datafeedId;
        @Nullable
        private List<CatDatafeedColumn> h;
        @Nullable
        private List<CatDatafeedColumn> s;
        @Nullable
        private TimeUnit time;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder h(List<CatDatafeedColumn> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(CatDatafeedColumn value, CatDatafeedColumn ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder s(List<CatDatafeedColumn> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(CatDatafeedColumn value, CatDatafeedColumn ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlDatafeedsRequest build() {
            this._checkSingleUse();
            return new MlDatafeedsRequest(this);
        }
    }
}

