/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.TypeUtil;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.scanner.api.annotation.field.ChineseDescription;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassReflectUtil {
    private static Map<String, String> runMap = new HashMap<String, String>(2);

    public static Set<FieldMetadata> getClassFieldDescription(Class<?> clazz) {
        HashSet<FieldMetadata> fieldDescriptions = new HashSet<FieldMetadata>();
        if (clazz == null) {
            return fieldDescriptions;
        }
        String runing = runMap.get(clazz.getName());
        if (ObjectUtil.isNotEmpty((Object)runing)) {
            return null;
        }
        while (clazz != null) {
            Field[] declaredFields;
            runMap.put(clazz.getName(), clazz.getName());
            for (Field declaredField : declaredFields = ClassUtil.getDeclaredFields(clazz)) {
                FieldMetadata fieldDescription = ClassReflectUtil.getFieldMetadata(declaredField);
                fieldDescriptions.add(fieldDescription);
            }
            runMap.remove(clazz.getName());
            clazz = clazz.getSuperclass();
        }
        return fieldDescriptions;
    }

    private static FieldMetadata getFieldMetadata(Field declaredField) {
        Class genericClass;
        FieldMetadata fieldDescription = new FieldMetadata();
        fieldDescription.setMetadataId(IdUtil.fastSimpleUUID());
        String name = declaredField.getName();
        fieldDescription.setFieldName(name);
        Class<?> declaredFieldType = declaredField.getType();
        fieldDescription.setFieldClassType(declaredFieldType.getSimpleName());
        fieldDescription.setFieldClassPath(declaredFieldType.getName());
        if (BaseRequest.class.isAssignableFrom(declaredFieldType)) {
            fieldDescription.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(declaredFieldType));
        } else if (List.class.isAssignableFrom(declaredFieldType)) {
            ParameterizedType pt;
            Type typeArgument;
            Type genericType = declaredField.getGenericType();
            Class<Object> actualTypeArgument = genericType instanceof ParameterizedType ? (!((typeArgument = (pt = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof WildcardType) ? (Class<Object>)pt.getActualTypeArguments()[0] : Object.class) : Object.class;
            if (actualTypeArgument.isPrimitive() || "java.lang".equals(actualTypeArgument.getPackage().getName()) || "java.util".equals(actualTypeArgument.getPackage().getName())) {
                Annotation[] item = new FieldMetadata();
                item.setMetadataId(IdUtil.fastSimpleUUID());
                item.setFieldName(actualTypeArgument.getName());
                item.setFieldClassType(actualTypeArgument.getTypeName());
                ChineseDescription chineseDescription = declaredField.getAnnotation(ChineseDescription.class);
                if (chineseDescription != null) {
                    item.setChineseName(chineseDescription.value());
                }
                fieldDescription.setGenericFieldMetadata(Collections.singleton(item));
            } else {
                fieldDescription.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(actualTypeArgument));
            }
        } else if (Collection.class.isAssignableFrom(declaredFieldType) && BaseRequest.class.isAssignableFrom(genericClass = TypeUtil.getClass((Type)TypeUtil.getTypeArgument((Type)TypeUtil.getType((Field)declaredField))))) {
            fieldDescription.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(genericClass));
        }
        Annotation[] annotations = declaredField.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            fieldDescription.setAnnotations(ClassReflectUtil.annotationsToStrings(annotations));
            HashMap<String, Set<String>> groupAnnotations = new HashMap<String, Set<String>>();
            for (Annotation annotation : annotations) {
                Class[] validateGroupsClasses = ClassReflectUtil.invokeAnnotationMethodIgnoreError(annotation, "groups", Class[].class);
                if (validateGroupsClasses == null) continue;
                for (Class validateGroupsClass : validateGroupsClasses) {
                    ClassReflectUtil.addGroupValidateAnnotation(annotation, validateGroupsClass, groupAnnotations);
                }
            }
            fieldDescription.setGroupValidationMessage(groupAnnotations);
            ChineseDescription chineseDescription = declaredField.getAnnotation(ChineseDescription.class);
            if (chineseDescription != null) {
                fieldDescription.setChineseName(chineseDescription.value());
            }
        }
        return fieldDescription;
    }

    private static <T> T invokeAnnotationMethodIgnoreError(Annotation apiResource, String methodName, Class<T> resultType) {
        try {
            Class<? extends Annotation> annotationType = apiResource.annotationType();
            Method method = annotationType.getMethod(methodName, new Class[0]);
            return (T)method.invoke((Object)apiResource, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static void addGroupValidateAnnotation(Annotation fieldAnnotation, Class<?> validateGroupsClass, Map<String, Set<String>> groupAnnotations) {
        Set<String> annotations = groupAnnotations.get(validateGroupsClass.getSimpleName());
        if (annotations == null) {
            annotations = new HashSet<String>();
        }
        String messageTip = ClassReflectUtil.invokeAnnotationMethodIgnoreError(fieldAnnotation, "message", String.class);
        annotations.add(messageTip);
        groupAnnotations.put(validateGroupsClass.getSimpleName(), annotations);
    }

    private static Set<String> annotationsToStrings(Annotation[] annotations) {
        HashSet<String> strings = new HashSet<String>();
        if (annotations == null || annotations.length == 0) {
            return strings;
        }
        for (Annotation annotation : annotations) {
            strings.add(annotation.annotationType().getSimpleName());
        }
        return strings;
    }
}

