/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.schedule;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.schedule.ScheduleListResult;
import cn.jpush.api.schedule.ScheduleResult;
import cn.jpush.api.schedule.model.SchedulePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleClient {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleClient.class);
    private final NativeHttpClient _httpClient;
    private String hostName;
    private String schedulePath;
    private int apnsProduction;
    private long timeToLive;

    public ScheduleClient(String masterSecret, String appkey) {
        this(masterSecret, appkey, null, ClientConfig.getInstance());
    }

    @Deprecated
    public ScheduleClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    @Deprecated
    public ScheduleClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        ClientConfig conf = ClientConfig.getInstance();
        conf.setMaxRetryTimes(maxRetryTimes);
        this.hostName = (String)conf.get((Object)"schedule.host.name");
        this.schedulePath = (String)conf.get((Object)"schedule.path");
        this.apnsProduction = (Integer)conf.get((Object)"apns.production");
        this.timeToLive = (Long)conf.get((Object)"time.to.live");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public ScheduleClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        this.hostName = (String)conf.get((Object)"schedule.host.name");
        this.schedulePath = (String)conf.get((Object)"schedule.path");
        this.apnsProduction = (Integer)conf.get((Object)"apns.production");
        this.timeToLive = (Long)conf.get((Object)"time.to.live");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public ScheduleResult createSchedule(SchedulePayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"payload should not be null");
        if (this.apnsProduction > 0) {
            payload.resetPushApnsProduction(true);
        } else if (this.apnsProduction == 0) {
            payload.resetPushApnsProduction(false);
        }
        if (this.timeToLive >= 0L) {
            payload.resetPushTimeToLive(this.timeToLive);
        }
        ResponseWrapper response = this._httpClient.sendPost(this.hostName + this.schedulePath, payload.toString());
        return (ScheduleResult)ScheduleResult.fromResponse((ResponseWrapper)response, ScheduleResult.class);
    }

    public ScheduleListResult getScheduleList(int page) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((page > 0 ? 1 : 0) != 0, (Object)"page should more than 0.");
        ResponseWrapper response = this._httpClient.sendGet(this.hostName + this.schedulePath + "?page=" + page);
        return (ScheduleListResult)ScheduleListResult.fromResponse((ResponseWrapper)response, ScheduleListResult.class);
    }

    public ScheduleResult getSchedule(String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"scheduleId should not be empty");
        ResponseWrapper response = this._httpClient.sendGet(this.hostName + this.schedulePath + "/" + scheduleId);
        return (ScheduleResult)ScheduleResult.fromResponse((ResponseWrapper)response, ScheduleResult.class);
    }

    public ScheduleResult updateSchedule(String scheduleId, SchedulePayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"scheduleId should not be empty");
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"payload should not be null");
        if (this.apnsProduction > 0) {
            payload.resetPushApnsProduction(true);
        } else if (this.apnsProduction == 0) {
            payload.resetPushApnsProduction(false);
        }
        if (this.timeToLive >= 0L) {
            payload.resetPushTimeToLive(this.timeToLive);
        }
        ResponseWrapper response = this._httpClient.sendPut(this.hostName + this.schedulePath + "/" + scheduleId, payload.toString());
        return (ScheduleResult)ScheduleResult.fromResponse((ResponseWrapper)response, ScheduleResult.class);
    }

    public void deleteSchedule(String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"scheduleId should not be empty");
        this._httpClient.sendDelete(this.hostName + this.schedulePath + "/" + scheduleId);
    }
}

