/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.fileconvertor.v03;

import cn.idev.excel.fileconvertor.BaseExcelConverter;
import cn.idev.excel.fileconvertor.Excel2PdfUtils;
import cn.idev.excel.fileconvertor.FileConverterContext;
import cn.idev.excel.fileconvertor.v03.XlsImageTableRenderer;
import cn.idev.excel.util.StringUtils;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.DashedBorder;
import com.itextpdf.layout.borders.DottedBorder;
import com.itextpdf.layout.borders.DoubleBorder;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.renderer.IRenderer;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsConverter
extends BaseExcelConverter {
    public XlsConverter(FileConverterContext context) {
        super(context);
    }

    @Override
    public void addPicsToTable(Table table, Sheet sheet) {
        HSSFPatriarch drawingPatriarch = ((HSSFSheet)sheet).getDrawingPatriarch();
        if (drawingPatriarch != null) {
            ArrayList<HSSFPicture> pictures = new ArrayList<HSSFPicture>();
            for (HSSFShape shape : drawingPatriarch.getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                pictures.add((HSSFPicture)shape);
            }
            table.setNextRenderer((IRenderer)new XlsImageTableRenderer(table, pictures, (HSSFSheet)sheet));
        }
    }

    @Override
    public Cell convertCell(org.apache.poi.ss.usermodel.Cell cell, int rowspan, int colspan, float maxWidth, String fontPath) throws IOException {
        String value = Excel2PdfUtils.getValue(cell);
        Cell pdfCell = this.createPdfCell(rowspan, colspan, cell, value, maxWidth, fontPath);
        return pdfCell;
    }

    private Cell createPdfCell(int rowspan, int colspan, org.apache.poi.ss.usermodel.Cell cell, String value, float maxWidth, String fontPath) throws IOException {
        float cellHeight = cell.getRow().getHeightInPoints() * 1.2f;
        Cell pdfCell = (Cell)((Cell)new Cell(rowspan, colspan).setHeight(cellHeight)).setPadding(0.0f);
        Text text = new Text(value);
        this.setPdfCellFont((HSSFCell)cell, text, fontPath);
        Paragraph paragraph = (Paragraph)((Paragraph)new Paragraph(text).setPadding(0.0f)).setMargin(0.0f);
        HSSFCellStyle cellStyle = ((HSSFCell)cell).getCellStyle();
        if (cellStyle.getWrapText()) {
            paragraph.setMaxWidth(maxWidth);
        }
        pdfCell.add((IBlockElement)paragraph);
        this.setCellStyles(cell, pdfCell);
        return pdfCell;
    }

    private void setCellStyles(org.apache.poi.ss.usermodel.Cell cell, Cell pdfCell) throws IOException {
        HSSFCellStyle cellStyle = ((HSSFCell)cell).getCellStyle();
        pdfCell.setVerticalAlignment(XlsConverter.getVerticalAlignment(cellStyle.getVerticalAlignment()));
        pdfCell.setTextAlignment(XlsConverter.getTextAlignment(cellStyle.getAlignment(), cell.getCellType()));
        XlsConverter.transformBorders((HSSFCell)cell, pdfCell);
        this.setBackgroundColor(cellStyle, pdfCell, cell);
    }

    private void setBackgroundColor(HSSFCellStyle cellStyle, Cell pdfCell, org.apache.poi.ss.usermodel.Cell cell) {
        short colorIndex = cellStyle.getFillForegroundColor();
        HSSFWorkbook workbook = (HSSFWorkbook)cell.getSheet().getWorkbook();
        HSSFColor color = workbook.getCustomPalette().getColor(colorIndex);
        if (color != null && color.getIndex() != 64) {
            short[] triplet = color.getTriplet();
            int r = Math.min(triplet[0] + 32, 255);
            int g = Math.min(triplet[1] + 90, 255);
            int b = Math.min(triplet[2] + 60, 255);
            pdfCell.setBackgroundColor((Color)new DeviceRgb(r, g, b));
        }
    }

    public static void transformBorders(HSSFCell cell, Cell pdfCell) {
        HSSFCellStyle cellStyle = cell.getCellStyle();
        pdfCell.setBorderBottom(XlsConverter.getBorder(cellStyle.getBorderBottom(), cellStyle.getBottomBorderColor(), cell));
        pdfCell.setBorderLeft(XlsConverter.getBorder(cellStyle.getBorderLeft(), cellStyle.getLeftBorderColor(), cell));
        pdfCell.setBorderRight(XlsConverter.getBorder(cellStyle.getBorderRight(), cellStyle.getRightBorderColor(), cell));
        pdfCell.setBorderTop(XlsConverter.getBorder(cellStyle.getBorderTop(), cellStyle.getTopBorderColor(), cell));
    }

    private void setPdfCellFont(HSSFCell cell, Text text, String fontPath) throws IOException {
        HSSFCellStyle cellStyle = cell.getCellStyle();
        HSSFFont font = cellStyle.getFont((Workbook)cell.getSheet().getWorkbook());
        text.setFont(StringUtils.isEmpty(fontPath) ? PdfFontFactory.createFont() : PdfFontFactory.createFont((String)fontPath, (String)"Identity-H"));
        text.setFontSize((float)font.getFontHeightInPoints());
        HSSFColor hssfColor = font.getHSSFColor(cell.getSheet().getWorkbook());
        if (hssfColor != null && hssfColor.getIndex() != 64) {
            short[] triplet = hssfColor.getTriplet();
            text.setFontColor((Color)new DeviceRgb((int)triplet[0], (int)triplet[1], (int)triplet[2]));
        }
        if (font.getBold()) {
            text.setBold();
        }
        if (font.getItalic()) {
            text.setItalic();
        }
        if (font.getUnderline() == 1) {
            text.setUnderline(0.5f, -1.0f);
        }
    }

    public static Border getBorder(BorderStyle borderStyle, short colorIndex, HSSFCell cell) {
        HSSFPalette customPalette = cell.getSheet().getWorkbook().getCustomPalette();
        HSSFColor color = customPalette.getColor(colorIndex);
        Color defaultColor = color != null && color.getIndex() != 64 ? new DeviceRgb((int)color.getTriplet()[0], (int)color.getTriplet()[1], (int)color.getTriplet()[2]) : ColorConstants.BLACK;
        switch (borderStyle) {
            case THIN: {
                return new SolidBorder(defaultColor, 0.3f);
            }
            case MEDIUM: {
                return new SolidBorder(defaultColor, 0.5f);
            }
            case DASHED: {
                return new DashedBorder(defaultColor, 0.3f);
            }
            case DOTTED: {
                return new DottedBorder(defaultColor, 0.3f);
            }
            case THICK: {
                return new SolidBorder(defaultColor, 1.0f);
            }
            case DOUBLE: {
                return new DoubleBorder(defaultColor, 0.3f);
            }
            case MEDIUM_DASHED: {
                return new DashedBorder(defaultColor, 0.5f);
            }
        }
        return Border.NO_BORDER;
    }
}

