/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.fileconvertor;

import cn.idev.excel.fileconvertor.ExcelConverter;
import cn.idev.excel.fileconvertor.FileConverterContext;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.IOException;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class BaseExcelConverter
implements ExcelConverter {
    private final FileConverterContext context;

    public BaseExcelConverter(FileConverterContext context) {
        this.context = context;
    }

    @Override
    public void convertToPdf() {
        try {
            for (int sheetIndex : this.context.getSheets()) {
                this.processSheet(sheetIndex);
            }
            this.context.getDocument().close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processSheet(int sheetIndex) throws IOException {
        Sheet sheet = this.context.getWorkbook().getSheetAt(sheetIndex);
        if (sheet == null || sheet.getRow(0) == null) {
            return;
        }
        float[] columnWidths = this.getColumnWidths(sheet);
        Table table = new Table(columnWidths);
        this.addRowsToTable(table, sheet, columnWidths, this.context.getFountPath());
        this.context.getDocument().add((IBlockElement)table);
    }

    protected abstract void addPicsToTable(Table var1, Sheet var2);

    private void addRowsToTable(Table table, Sheet sheet, float[] columnWidths, String fontPath) throws IOException {
        int lastRowNum = sheet.getLastRowNum() + 1;
        short lastCellNum = sheet.getRow(0).getLastCellNum();
        for (int i = 0; i < lastRowNum; ++i) {
            Row row = sheet.getRow(i);
            this.addRowToTable(table, row, lastCellNum, columnWidths, fontPath);
        }
    }

    private void addRowToTable(Table table, Row row, int lastCellNum, float[] columnWidths, String fontPath) throws IOException {
        if (row == null) {
            this.addEmptyCells(table, lastCellNum);
            return;
        }
        for (int j = 0; j < lastCellNum; ++j) {
            Cell cell = row.getCell(j);
            if (cell != null && !this.isCellProcessed(cell)) {
                int colspan;
                CellRangeAddress cellRange = this.getCellRangeAddress(cell);
                int rowspan = cellRange != null ? cellRange.getLastRow() - cellRange.getFirstRow() + 1 : 1;
                int n = colspan = cellRange != null ? cellRange.getLastColumn() - cellRange.getFirstColumn() + 1 : 1;
                if (cellRange != null) {
                    j = cellRange.getLastColumn();
                }
                float maxWidth = cellRange != null ? this.calculateMaxWidth(columnWidths, cellRange) : columnWidths[j];
                com.itextpdf.layout.element.Cell pdfCell = this.convertCell(cell, rowspan, colspan, maxWidth, fontPath);
                table.addCell(pdfCell);
                continue;
            }
            if (cell != null) continue;
            this.addEmptyCell(table);
        }
    }

    private float calculateMaxWidth(float[] columnWidths, CellRangeAddress cellRange) {
        float maxWidth = 0.0f;
        for (int k = cellRange.getFirstColumn(); k < cellRange.getLastColumn(); ++k) {
            maxWidth += columnWidths[k];
        }
        return maxWidth;
    }

    private void addEmptyCell(Table table) {
        com.itextpdf.layout.element.Cell pdfCell = new com.itextpdf.layout.element.Cell();
        pdfCell.setBorder(Border.NO_BORDER);
        table.addCell(pdfCell);
    }

    private void addEmptyCells(Table table, int numberOfCells) {
        for (int j = 0; j < numberOfCells; ++j) {
            this.addEmptyCell(table);
        }
    }

    protected abstract com.itextpdf.layout.element.Cell convertCell(Cell var1, int var2, int var3, float var4, String var5) throws IOException;

    public static VerticalAlignment getVerticalAlignment(org.apache.poi.ss.usermodel.VerticalAlignment verticalAlignment) {
        switch (verticalAlignment) {
            case TOP: {
                return VerticalAlignment.TOP;
            }
            case BOTTOM: {
                return VerticalAlignment.BOTTOM;
            }
            case JUSTIFY: 
            case CENTER: {
                return VerticalAlignment.MIDDLE;
            }
        }
        return VerticalAlignment.MIDDLE;
    }

    public static TextAlignment getTextAlignment(HorizontalAlignment alignment, CellType cellType) {
        switch (alignment) {
            case LEFT: {
                return TextAlignment.LEFT;
            }
            case RIGHT: {
                return TextAlignment.RIGHT;
            }
            case CENTER: {
                return TextAlignment.CENTER;
            }
            case JUSTIFY: {
                return TextAlignment.JUSTIFIED;
            }
            case GENERAL: {
                if (cellType == CellType.NUMERIC) {
                    return TextAlignment.RIGHT;
                }
                if (cellType != CellType.BOOLEAN) break;
                return TextAlignment.CENTER;
            }
        }
        return TextAlignment.LEFT;
    }

    private float[] getColumnWidths(Sheet sheet) {
        int lastCellNum = sheet.getRow(0).getLastCellNum();
        float[] widths = new float[lastCellNum];
        for (int i = 0; i < lastCellNum; ++i) {
            widths[i] = sheet.getColumnWidthInPixels(i);
        }
        return widths;
    }

    private boolean isCellProcessed(Cell cell) {
        List mergedRegions = cell.getSheet().getMergedRegions();
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        for (CellRangeAddress cellAddresses : mergedRegions) {
            if (cellAddresses.getFirstRow() > rowIndex || cellAddresses.getLastRow() < rowIndex || cellAddresses.getFirstColumn() > columnIndex || cellAddresses.getLastColumn() < columnIndex) continue;
            return cellAddresses.getFirstRow() != rowIndex || cellAddresses.getFirstColumn() != columnIndex;
        }
        return false;
    }

    private CellRangeAddress getCellRangeAddress(Cell cell) {
        List mergedRegions = cell.getSheet().getMergedRegions();
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        for (CellRangeAddress cellAddresses : mergedRegions) {
            if (cellAddresses.getFirstRow() != rowIndex || cellAddresses.getFirstColumn() != columnIndex) continue;
            return cellAddresses;
        }
        return null;
    }
}

