/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.generic.ANEWARRAY;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.GETSTATIC;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.INVOKESPECIAL;
import org.aspectj.apache.bcel.generic.INVOKESTATIC;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.MONITORENTER;
import org.aspectj.apache.bcel.generic.MONITOREXIT;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.NEWARRAY;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.PUTSTATIC;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.ClassLoaderRepository;
import org.aspectj.apache.bcel.util.ClassPath;
import org.aspectj.apache.bcel.util.Repository;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberImpl;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.asm.AsmDelegate;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelCflowCounterFieldAdder;
import org.aspectj.weaver.bcel.BcelCflowStackFieldAdder;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelPerClauseAspectAdder;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.ClassPathManager;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.SimpleScope;

public class BcelWorld
extends World
implements Repository {
    private ClassPathManager classPath;
    private Repository delegate;
    public boolean fallbackToLoadingBcelDelegatesForAspects = true;
    private int packageRestrictionsForFastDelegates = 0;
    private List packagePrefixRestrictionList = null;
    private static final String[] ZERO_STRINGS = new String[0];

    public BcelWorld() {
        this("");
    }

    public BcelWorld(String cp) {
        this(BcelWorld.makeDefaultClasspath(cp), IMessageHandler.THROW, null);
    }

    private static List makeDefaultClasspath(String cp) {
        ArrayList classPath = new ArrayList();
        classPath.addAll(BcelWorld.getPathEntries(cp));
        classPath.addAll(BcelWorld.getPathEntries(ClassPath.getClassPath()));
        return classPath;
    }

    private static List getPathEntries(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(s, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            ret.add(tok.nextToken());
        }
        return ret;
    }

    public BcelWorld(List classPath, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = new ClassPathManager(classPath, handler);
        this.setMessageHandler(handler);
        this.setCrossReferenceHandler(xrefHandler);
        this.delegate = this;
    }

    public BcelWorld(ClassPathManager cpm, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = cpm;
        this.setMessageHandler(handler);
        this.setCrossReferenceHandler(xrefHandler);
        this.delegate = this;
    }

    public BcelWorld(ClassLoader loader, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = null;
        this.setMessageHandler(handler);
        this.setCrossReferenceHandler(xrefHandler);
        this.delegate = new ClassLoaderRepository(loader);
    }

    public void addPath(String name) {
        this.classPath.addPath(name, this.getMessageHandler());
    }

    public Advice shadowMunger(String str, int extraFlag) {
        str = str.trim();
        int start = 0;
        int i = str.indexOf(40);
        AdviceKind kind = AdviceKind.stringToKind(str.substring(start, i));
        start = ++i;
        i = str.indexOf(41, i);
        String[] ids = this.parseIds(str.substring(start, i).trim());
        i = str.indexOf(58, i);
        start = ++i;
        i = str.indexOf("->", i);
        Pointcut pointcut = Pointcut.fromString(str.substring(start, i).trim());
        Member m = MemberImpl.methodFromString(str.substring(i + 2, str.length()).trim());
        UnresolvedType[] types = m.getParameterTypes();
        FormalBinding[] bindings = new FormalBinding[ids.length];
        int len = ids.length;
        for (int j = 0; j < len; ++j) {
            bindings[j] = new FormalBinding(types[j], ids[j], j, 0, 0, "fromString");
        }
        Pointcut p = pointcut.resolve(new SimpleScope(this, bindings));
        return new BcelAdvice(kind, p, m, extraFlag, 0, 0, null, null);
    }

    private String[] parseIds(String str) {
        if (str.length() == 0) {
            return ZERO_STRINGS;
        }
        ArrayList<String> l = new ArrayList<String>();
        int start = 0;
        while (true) {
            int i;
            if ((i = str.indexOf(44, start)) == -1) break;
            l.add(str.substring(start, i).trim());
            start = i + 1;
        }
        l.add(str.substring(start).trim());
        return l.toArray(new String[l.size()]);
    }

    public static Type makeBcelType(UnresolvedType type) {
        return Type.getType(type.getErasureSignature());
    }

    static Type[] makeBcelTypes(UnresolvedType[] types) {
        Type[] ret = new Type[types.length];
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = BcelWorld.makeBcelType(types[i]);
        }
        return ret;
    }

    static String[] makeBcelTypesAsClassNames(UnresolvedType[] types) {
        String[] ret = new String[types.length];
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = types[i].getName();
        }
        return ret;
    }

    public static UnresolvedType fromBcel(Type t) {
        return UnresolvedType.forSignature(t.getSignature());
    }

    static UnresolvedType[] fromBcel(Type[] ts) {
        UnresolvedType[] ret = new UnresolvedType[ts.length];
        int len = ts.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = BcelWorld.fromBcel(ts[i]);
        }
        return ret;
    }

    public ResolvedType resolve(Type t) {
        return this.resolve(BcelWorld.fromBcel(t));
    }

    public boolean isNotOnPackageRestrictedList(String s) {
        if (this.packageRestrictionsForFastDelegates == 0) {
            String possiblePackageRestrictions;
            Properties p = this.getExtraConfiguration();
            String string = possiblePackageRestrictions = p == null ? null : p.getProperty("fastDelegateRestrictions");
            if (possiblePackageRestrictions == null) {
                this.packageRestrictionsForFastDelegates = 1;
            } else {
                this.packageRestrictionsForFastDelegates = 2;
                this.packagePrefixRestrictionList = new ArrayList();
                StringTokenizer st = new StringTokenizer(possiblePackageRestrictions, ":");
                while (st.hasMoreTokens()) {
                    this.packagePrefixRestrictionList.add(st.nextToken());
                }
            }
        }
        if (this.packageRestrictionsForFastDelegates == 1) {
            return true;
        }
        if (this.packageRestrictionsForFastDelegates == 2) {
            Iterator iter = this.packagePrefixRestrictionList.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                if (!s.startsWith(element)) continue;
                return false;
            }
        }
        return true;
    }

    protected ReferenceTypeDelegate resolveDelegate(ReferenceType ty) {
        String name = ty.getName();
        JavaClass jc = null;
        this.ensureAdvancedConfigurationProcessed();
        if (this.isFastDelegateSupportEnabled() && this.classPath != null && !ty.needsModifiableDelegate() && this.isNotOnPackageRestrictedList(name)) {
            ClassPathManager.ClassFile cf = this.classPath.find(ty);
            if (cf == null) {
                return null;
            }
            ReferenceTypeDelegate delegate = this.buildAsmDelegate(ty, cf);
            if (this.fallbackToLoadingBcelDelegatesForAspects && delegate.isAspect()) {
                if (jc == null) {
                    jc = this.lookupJavaClass(this.classPath, name);
                }
                if (jc == null) {
                    return delegate;
                }
                return this.buildBcelDelegate(ty, jc, false);
            }
            return delegate;
        }
        if (jc == null) {
            jc = this.lookupJavaClass(this.classPath, name);
        }
        if (jc == null) {
            return null;
        }
        return this.buildBcelDelegate(ty, jc, false);
    }

    private ReferenceTypeDelegate buildAsmDelegate(ReferenceType type, ClassPathManager.ClassFile t) {
        AsmDelegate asmDelegate;
        try {
            asmDelegate = new AsmDelegate(type, t.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return asmDelegate;
    }

    public BcelObjectType buildBcelDelegate(ReferenceType resolvedTypeX, JavaClass jc, boolean exposedToWeaver) {
        BcelObjectType ret = new BcelObjectType(resolvedTypeX, jc, exposedToWeaver);
        return ret;
    }

    private JavaClass lookupJavaClass(ClassPathManager classPath, String name) {
        if (classPath == null) {
            try {
                return this.delegate.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        try {
            ClassPathManager.ClassFile file = classPath.find(UnresolvedType.forName(name));
            if (file == null) {
                return null;
            }
            ClassParser parser = new ClassParser(file.getInputStream(), file.getPath());
            JavaClass jc = parser.parse();
            file.close();
            return jc;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public BcelObjectType addSourceObjectType(JavaClass jc) {
        BcelObjectType ret = null;
        String signature = UnresolvedType.forName(jc.getClassName()).getSignature();
        ResolvedType fromTheMap = this.typeMap.get(signature);
        if (fromTheMap != null && !(fromTheMap instanceof ReferenceType)) {
            StringBuffer exceptionText = new StringBuffer();
            exceptionText.append("Found invalid (not a ReferenceType) entry in the type map. ");
            exceptionText.append("Signature=[" + signature + "] Found=[" + fromTheMap + "] Class=[" + fromTheMap.getClass() + "]");
            throw new BCException(exceptionText.toString());
        }
        ReferenceType nameTypeX = (ReferenceType)fromTheMap;
        if (nameTypeX == null) {
            if (jc.isGeneric() && this.isInJava5Mode()) {
                nameTypeX = ReferenceType.fromTypeX(UnresolvedType.forRawTypeName(jc.getClassName()), this);
                ret = this.buildBcelDelegate(nameTypeX, jc, true);
                ReferenceType genericRefType = new ReferenceType(UnresolvedType.forGenericTypeSignature(signature, ret.getDeclaredGenericSignature()), (World)this);
                nameTypeX.setDelegate(ret);
                genericRefType.setDelegate(ret);
                nameTypeX.setGenericType(genericRefType);
                this.typeMap.put(signature, nameTypeX);
            } else {
                nameTypeX = new ReferenceType(signature, (World)this);
                ret = this.buildBcelDelegate(nameTypeX, jc, true);
                this.typeMap.put(signature, nameTypeX);
            }
        } else {
            ret = this.buildBcelDelegate(nameTypeX, jc, true);
        }
        return ret;
    }

    void deleteSourceObjectType(UnresolvedType ty) {
        this.typeMap.remove(ty.getSignature());
    }

    public static Member makeFieldJoinPointSignature(LazyClassGen cg, FieldInstruction fi) {
        ConstantPoolGen cpg = cg.getConstantPoolGen();
        return MemberImpl.field(fi.getClassName(cpg), fi instanceof GETSTATIC || fi instanceof PUTSTATIC ? 8 : 0, fi.getName(cpg), fi.getSignature(cpg));
    }

    public Member makeJoinPointSignature(LazyMethodGen mg) {
        return this.makeJoinPointSignatureFromMethod(mg, null);
    }

    public Member makeJoinPointSignatureFromMethod(LazyMethodGen mg, Member.Kind kind) {
        BcelMethod ret = mg.getMemberView();
        if (ret == null) {
            int mods = mg.getAccessFlags();
            if (mg.getEnclosingClass().isInterface()) {
                mods |= 0x200;
            }
            if (kind == null) {
                kind = mg.getName().equals("<init>") ? Member.CONSTRUCTOR : (mg.getName().equals("<clinit>") ? Member.STATIC_INITIALIZATION : Member.METHOD);
            }
            return new ResolvedMemberImpl(kind, UnresolvedType.forName(mg.getClassName()), mods, BcelWorld.fromBcel(mg.getReturnType()), mg.getName(), BcelWorld.fromBcel(mg.getArgumentTypes()));
        }
        return ret;
    }

    public Member makeJoinPointSignatureForMonitorEnter(LazyClassGen cg, InstructionHandle h) {
        MONITORENTER i = (MONITORENTER)h.getInstruction();
        return MemberImpl.monitorEnter();
    }

    public Member makeJoinPointSignatureForMonitorExit(LazyClassGen cg, InstructionHandle h) {
        MONITOREXIT i = (MONITOREXIT)h.getInstruction();
        return MemberImpl.monitorExit();
    }

    public Member makeJoinPointSignatureForArrayConstruction(LazyClassGen cg, InstructionHandle handle) {
        Instruction i = handle.getInstruction();
        ConstantPoolGen cpg = cg.getConstantPoolGen();
        MemberImpl retval = null;
        if (i instanceof ANEWARRAY) {
            ANEWARRAY arrayInstruction = (ANEWARRAY)i;
            Type ot = arrayInstruction.getType(cpg);
            UnresolvedType ut = BcelWorld.fromBcel(ot);
            ut = UnresolvedType.makeArray(ut, 1);
            retval = MemberImpl.method(ut, 1, ResolvedType.VOID, "<init>", new ResolvedType[]{ResolvedType.INT});
        } else if (i instanceof MULTIANEWARRAY) {
            MULTIANEWARRAY arrayInstruction = (MULTIANEWARRAY)i;
            UnresolvedType ut = null;
            int dimensions = arrayInstruction.getDimensions();
            ObjectType ot = arrayInstruction.getLoadClassType(cpg);
            if (ot != null) {
                ut = BcelWorld.fromBcel(ot);
                ut = UnresolvedType.makeArray(ut, dimensions);
            } else {
                Type t = arrayInstruction.getType(cpg);
                ut = BcelWorld.fromBcel(t);
            }
            UnresolvedType[] parms = new ResolvedType[dimensions];
            for (int ii = 0; ii < dimensions; ++ii) {
                parms[ii] = ResolvedType.INT;
            }
            retval = MemberImpl.method(ut, 1, ResolvedType.VOID, "<init>", parms);
        } else if (i instanceof NEWARRAY) {
            NEWARRAY arrayInstruction = (NEWARRAY)i;
            Type ot = arrayInstruction.getType();
            UnresolvedType ut = BcelWorld.fromBcel(ot);
            retval = MemberImpl.method(ut, 1, ResolvedType.VOID, "<init>", new ResolvedType[]{ResolvedType.INT});
        } else {
            throw new BCException("Cannot create array construction signature for this non-array instruction:" + i);
        }
        return retval;
    }

    public Member makeJoinPointSignatureForMethodInvocation(LazyClassGen cg, InvokeInstruction ii) {
        int modifier;
        ConstantPoolGen cpg = cg.getConstantPoolGen();
        String name = ii.getName(cpg);
        String declaring = ii.getClassName(cpg);
        UnresolvedType declaringType = null;
        String signature = ii.getSignature(cpg);
        int n = ii instanceof INVOKEINTERFACE ? 512 : (ii instanceof INVOKESTATIC ? 8 : (modifier = ii instanceof INVOKESPECIAL && !name.equals("<init>") ? 2 : 0));
        if (ii instanceof INVOKESTATIC) {
            ResolvedType appearsDeclaredBy = this.resolve(declaring);
            Iterator iterator = appearsDeclaredBy.getMethods();
            while (iterator.hasNext()) {
                ResolvedMember method = (ResolvedMember)iterator.next();
                if (!method.isStatic() || !name.equals(method.getName()) || !signature.equals(method.getSignature())) continue;
                declaringType = method.getDeclaringType();
                break;
            }
        }
        if (declaringType == null) {
            declaringType = declaring.charAt(0) == '[' ? UnresolvedType.forSignature(declaring) : UnresolvedType.forName(declaring);
        }
        return MemberImpl.method(declaringType, modifier, name, signature);
    }

    public static Member makeMungerMethodSignature(JavaClass javaClass, Method method) {
        int mods = 0;
        if (method.isStatic()) {
            mods = 8;
        } else if (javaClass.isInterface()) {
            mods = 512;
        } else if (method.isPrivate()) {
            mods = 2;
        }
        return MemberImpl.method(UnresolvedType.forName(javaClass.getClassName()), mods, method.getName(), method.getSignature());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("BcelWorld(");
        buf.append(")");
        return buf.toString();
    }

    public Advice createAdviceMunger(AjAttribute.AdviceAttribute attribute, Pointcut pointcut, Member signature) {
        return new BcelAdvice(attribute, pointcut, signature, null);
    }

    public ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger munger, ResolvedType aspectType) {
        return new BcelTypeMunger(munger, aspectType);
    }

    public ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember cflowField) {
        return new BcelCflowStackFieldAdder(cflowField);
    }

    public ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember cflowField) {
        return new BcelCflowCounterFieldAdder(cflowField);
    }

    public ConcreteTypeMunger makePerClauseAspect(ResolvedType aspect, PerClause.Kind kind) {
        return new BcelPerClauseAspectAdder(aspect, kind);
    }

    public static BcelObjectType getBcelObjectType(ResolvedType concreteAspect) {
        ReferenceTypeDelegate rtDelegate = ((ReferenceType)concreteAspect).getDelegate();
        if (rtDelegate instanceof BcelObjectType) {
            return (BcelObjectType)rtDelegate;
        }
        return null;
    }

    public void tidyUp() {
        this.classPath.closeArchives();
        this.typeMap.report();
        ResolvedType.resetPrimitives();
    }

    public JavaClass findClass(String className) {
        return this.lookupJavaClass(this.classPath, className);
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        return this.lookupJavaClass(this.classPath, className);
    }

    public void storeClass(JavaClass clazz) {
        throw new RuntimeException("Not implemented");
    }

    public void removeClass(JavaClass clazz) {
        throw new RuntimeException("Not implemented");
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        throw new RuntimeException("Not implemented");
    }

    public void clear() {
        throw new RuntimeException("Not implemented");
    }

    public void validateType(UnresolvedType type) {
        ResolvedType result = this.typeMap.get(type.getSignature());
        if (result == null) {
            return;
        }
        if (!result.isExposedToWeaver()) {
            return;
        }
        ReferenceType rt = (ReferenceType)result;
        rt.getDelegate().ensureDelegateConsistent();
    }

    public boolean isAnnotationStyleAspect(String name, byte[] bytes) {
        try {
            ClassParser cp = new ClassParser(new ByteArrayInputStream(bytes), null);
            JavaClass jc = cp.parse();
            if (!jc.isClass()) {
                return false;
            }
            Annotation[] anns = jc.getAnnotations();
            if (anns.length == 0) {
                return false;
            }
            boolean couldBeAtAspectJStyle = false;
            for (int i = 0; i < anns.length; ++i) {
                Annotation ann = anns[i];
                if (!"Lorg/aspectj/lang/annotation/Aspect;".equals(ann.getTypeSignature())) continue;
                couldBeAtAspectJStyle = true;
            }
            if (!couldBeAtAspectJStyle) {
                return false;
            }
            Attribute[] attributes = jc.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals("org.aspectj.weaver.Aspect")) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return true;
        }
    }
}

