/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.monitor.athena.reporter.impl;

import com.meidusa.venus.monitor.athena.AthenaTransactionId;
import com.meidusa.venus.monitor.athena.reporter.ServerTransactionReporter;
import com.meidusa.venus.monitor.athena.reporter.impl.AbstractTransactionReporter;
import com.meidusa.venus.monitor.athena.support.TransactionThreadLocal;
import com.saic.framework.athena.configuration.client.entity.RemoteContext;
import com.saic.framework.athena.configuration.client.entity.impl.RemoteContextInstance;
import com.saic.framework.athena.message.Transaction;
import com.saic.framework.athena.site.helper.AthenaUtils;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerTransactionReporter
extends AbstractTransactionReporter
implements ServerTransactionReporter {
    private static Logger logger = LoggerFactory.getLogger(DefaultServerTransactionReporter.class);

    @Override
    public void startTransaction(AthenaTransactionId transactionId, String itemName) {
        try {
            RemoteContextInstance context = new RemoteContextInstance();
            context.addProperty("_athenaRootMessageId", transactionId.getRootId());
            context.addProperty("_athenaParentMessageId", transactionId.getParentId());
            context.addProperty("_athenaChildMessageId", transactionId.getMessageId());
            AthenaUtils.getInstance().logRemoteCallServer((RemoteContext)context);
            Stack transactionStack = (Stack)TransactionThreadLocal.getInstance().get();
            Transaction transaction = AthenaUtils.getInstance().newTransaction("rpc_server", itemName);
            if (transaction != null) {
                transactionStack.add(transaction);
            }
        }
        catch (Exception e) {
            logger.error("server startTransaction error.", (Throwable)e);
        }
    }
}

