/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.monitor.athena.reporter.impl;

import com.meidusa.venus.monitor.athena.reporter.MetricReporter;
import com.saic.framework.athena.site.helper.AthenaUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricReporter
implements MetricReporter {
    private static Logger logger = LoggerFactory.getLogger(DefaultMetricReporter.class);
    private static ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private static Map<String, AtomicLong> maps = new HashMap<String, AtomicLong>();

    @Override
    public void metric(String key) {
        this.metric(key, 1);
    }

    @Override
    public void metric(String key, int count) {
        try {
            AtomicLong value = maps.get(key);
            if (value == null) {
                value = new AtomicLong(1L);
                maps.put(key, value);
            } else {
                value.getAndAdd(count);
            }
        }
        catch (Exception e) {
            logger.error("set metric error", (Throwable)e);
        }
    }

    static {
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String key : maps.keySet()) {
                        AtomicLong value = (AtomicLong)maps.get(key);
                        long count = value.get();
                        value.set(0L);
                        if (count == 0L) continue;
                        AthenaUtils.getInstance().logMetirc(key, count);
                    }
                }
                catch (Exception e) {
                    logger.error("upload metric error", (Throwable)e);
                }
            }
        }, 60L, 15L, TimeUnit.SECONDS);
    }
}

