/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.router.condition;

import com.meidusa.venus.Invocation;
import com.meidusa.venus.URL;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.router.Router;
import com.meidusa.venus.client.router.condition.ConditionRuleParser;
import com.meidusa.venus.client.router.condition.rule.FullConditionRule;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.registry.domain.RouterRule;
import com.meidusa.venus.registry.domain.VenusServiceConfigDO;
import com.meidusa.venus.registry.domain.VenusServiceDefinitionDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ConditionRuleRouter
implements Router {
    private ConditionRuleParser ruleParser = new ConditionRuleParser();

    @Override
    public List<URL> filte(Invocation invocation, List<URL> urlList) {
        ClientInvocation clientInvocation = (ClientInvocation)invocation;
        ArrayList<URL> alllowUrlList = new ArrayList<URL>();
        for (URL url : urlList) {
            if (this.isReject(clientInvocation, url)) continue;
            alllowUrlList.add(url);
        }
        if (CollectionUtils.isEmpty(alllowUrlList)) {
            throw new RpcException("with rule filter,no allowed service providers.");
        }
        return alllowUrlList;
    }

    boolean isReject(ClientInvocation clientInvocation, URL url) {
        List<FullConditionRule> ruleDefList = this.getRouteRules(url);
        if (CollectionUtils.isEmpty(ruleDefList)) {
            return false;
        }
        for (FullConditionRule rule : ruleDefList) {
            if (!rule.isReject(clientInvocation, url)) continue;
            return true;
        }
        return false;
    }

    List<FullConditionRule> getRouteRules(URL url) {
        ArrayList<FullConditionRule> rules = new ArrayList<FullConditionRule>();
        VenusServiceDefinitionDO srvDef = (VenusServiceDefinitionDO)url.getServiceDefinition();
        if (srvDef == null) {
            return rules;
        }
        List srvCfgList = srvDef.getServiceConfigs();
        if (CollectionUtils.isEmpty((Collection)srvCfgList)) {
            return rules;
        }
        for (VenusServiceConfigDO srvCfg : srvCfgList) {
            RouterRule jsonRuleDef = srvCfg.getRouterRule();
            if (jsonRuleDef == null || !this.isValidRule(jsonRuleDef)) continue;
            FullConditionRule conditionRule = this.ruleParser.parse(jsonRuleDef);
            rules.add(conditionRule);
        }
        return rules;
    }

    boolean isValidRule(RouterRule ruleDef) {
        if (StringUtils.isEmpty((String)ruleDef.getExpress())) {
            return false;
        }
        String[] arr = ruleDef.getExpress().split("=>");
        if (arr == null || arr.length < 2) {
            return false;
        }
        return false;
    }
}

