/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.router.condition;

import com.meidusa.venus.client.router.condition.rule.FullConditionRule;
import com.meidusa.venus.client.router.condition.rule.LeftConditionRule;
import com.meidusa.venus.client.router.condition.rule.RightConditionRule;
import com.meidusa.venus.registry.domain.RouterRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ConditionRuleParser {
    public FullConditionRule parse(RouterRule ruleDef) {
        String exp = ruleDef.getExpress();
        String[] strDefArr = exp.split("=>");
        FullConditionRule fullRule = new FullConditionRule();
        String leftDef = strDefArr[0];
        LeftConditionRule leftRule = this.parseLeftRule(leftDef);
        fullRule.setLeftRule(leftRule);
        String rightDef = strDefArr[1];
        RightConditionRule rightRule = this.parseRightRule(rightDef);
        fullRule.setRightRule(rightRule);
        return fullRule;
    }

    LeftConditionRule parseLeftRule(String leftExp) {
        LeftConditionRule leftRule = new LeftConditionRule();
        List<RuleExpDef> defList = this.toRuleExpDefList(leftExp);
        if (CollectionUtils.isEmpty(defList)) {
            return leftRule;
        }
        for (RuleExpDef def : defList) {
            String name = def.getName();
            if ("consumer.app".equalsIgnoreCase(name)) {
                leftRule.setAppExp(def.getExp());
                leftRule.setAppValues(def.getValues());
                continue;
            }
            if (!"consumer.host".equalsIgnoreCase(name)) continue;
            leftRule.setHostExp(def.getExp());
            leftRule.setHostValues(def.getValues());
        }
        return leftRule;
    }

    RightConditionRule parseRightRule(String rightExp) {
        RightConditionRule rightRule = new RightConditionRule();
        List<RuleExpDef> defList = this.toRuleExpDefList(rightExp);
        if (CollectionUtils.isEmpty(defList)) {
            return rightRule;
        }
        for (RuleExpDef def : defList) {
            String name = def.getName();
            if (!"provider.host".equalsIgnoreCase(name)) continue;
            rightRule.setHostExp(def.getExp());
            rightRule.setHostValues(def.getValues());
        }
        return rightRule;
    }

    List<RuleExpDef> toRuleExpDefList(String strExp) {
        strExp = strExp.trim();
        ArrayList<RuleExpDef> defList = new ArrayList<RuleExpDef>();
        if ("*".equalsIgnoreCase(strExp)) {
            return defList;
        }
        String[] defArr = strExp.split("&");
        if (defArr != null && defArr.length > 0) {
            for (String def : defArr) {
                RuleExpDef expDef;
                String[] sDef = def.split("=");
                if (sDef != null && sDef.length > 0) {
                    expDef = new RuleExpDef();
                    expDef.setName(sDef[0]);
                    expDef.setExp("=");
                    expDef.setValues(sDef[1]);
                    defList.add(expDef);
                }
                if ((sDef = def.split("=>")) == null || sDef.length <= 0) continue;
                expDef = new RuleExpDef();
                expDef.setName(sDef[0]);
                expDef.setExp("!=");
                expDef.setValues(sDef[1]);
                defList.add(expDef);
            }
        }
        return defList;
    }

    class RuleExpDef {
        private String name;
        private String exp;
        private String values;

        RuleExpDef() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExp() {
            return this.exp;
        }

        public void setExp(String exp) {
            this.exp = exp;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }
    }
}

