/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.invoker.venus;

import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.invoker.venus.VenusReqRespWrapper;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.io.handler.Venus4BackendMessageHandler;
import com.meidusa.venus.io.network.Venus4BackendConnection;
import com.meidusa.venus.io.network.VenusBackendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.io.utils.RpcIdUtil;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;

public class VenusClientInvokerMessageHandler
extends Venus4BackendMessageHandler
implements MessageHandler<Venus4BackendConnection, byte[]> {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger tracerLogger = VenusLoggerFactory.getTracerLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private Map<String, VenusReqRespWrapper> serviceReqRespMap;
    private Map<String, ClientInvocation> serviceReqCallbackMap;

    public void handle(Venus4BackendConnection conn, byte[] message) {
        this.doHandle(conn, message);
    }

    void doHandle(Venus4BackendConnection conn, byte[] message) {
        Serializer serializer = SerializerFactory.getSerializer((short)conn.getSerializeType());
        int type = AbstractServicePacket.getType((byte[])message);
        switch (type) {
            case -1: {
                this.handleForError((VenusBackendConnection)conn, message, serializer);
                break;
            }
            case 1: {
                this.handleForOk((VenusBackendConnection)conn, message, serializer);
                break;
            }
            case 0x2000002: {
                this.handleForResponse((VenusBackendConnection)conn, message, serializer);
                break;
            }
            case 0x4000001: {
                this.handleForNotify((VenusBackendConnection)conn, message, serializer);
                break;
            }
            case 0x1000002: {
                super.handle(conn, message);
                break;
            }
            case 0x1000001: {
                super.handle(conn, message);
                break;
            }
            default: {
                super.handle(conn, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleForError(VenusBackendConnection conn, byte[] message, Serializer serializer) {
        VenusReqRespWrapper reqRespWrapper = null;
        try {
            ErrorPacket errorPacket = new ErrorPacket();
            errorPacket.init(message);
            String rpcId = RpcIdUtil.getRpcId((AbstractServicePacket)errorPacket);
            reqRespWrapper = this.serviceReqRespMap.get(rpcId);
            if (reqRespWrapper != null) {
                Logger trLogger = tracerLogger;
                if (VenusUtil.isAthenaInterface((Invocation)reqRespWrapper.getInvocation())) {
                    trLogger = logger;
                }
                if (trLogger.isInfoEnabled()) {
                    trLogger.info("[C] recv error response,rpcId:{},sourceIp:{}.", (Object)rpcId, (Object)conn.getHost());
                }
            }
            if (reqRespWrapper == null) {
                if (exceptionLogger.isErrorEnabled()) {
                    exceptionLogger.error("[C] handle error message failed,rpcId:{},sourceIp:{},reason:{}.", new Object[]{rpcId, conn.getHost(), "Already handled."});
                }
                return;
            }
            Throwable exception = this.buildExceptionFromErrorPacket(errorPacket, serializer, (VenusExceptionFactory)XmlVenusExceptionFactory.getInstance());
            Result result = new Result();
            result.setException(exception);
            result.setErrorCode(errorPacket.errorCode);
            reqRespWrapper.setResult(result);
        }
        catch (Exception e) {
            reqRespWrapper.setResult(new Result().setException((Throwable)e));
        }
        finally {
            if (reqRespWrapper != null && reqRespWrapper.getReqRespLatch() != null) {
                reqRespWrapper.getReqRespLatch().countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleForResponse(VenusBackendConnection conn, byte[] message, Serializer serializer) {
        VenusReqRespWrapper reqRespWrapper = null;
        try {
            AbstractServicePacket packet = this.parseServicePacket(message);
            String rpcId = RpcIdUtil.getRpcId((AbstractServicePacket)packet);
            reqRespWrapper = this.serviceReqRespMap.get(rpcId);
            if (reqRespWrapper != null) {
                Logger trLogger = tracerLogger;
                if (VenusUtil.isAthenaInterface((Invocation)reqRespWrapper.getInvocation())) {
                    trLogger = logger;
                }
                if (trLogger.isInfoEnabled()) {
                    trLogger.info("[C] recv reponse,rpcId:{},sourceIp:{}.", (Object)rpcId, (Object)conn.getHost());
                }
            }
            if (reqRespWrapper == null) {
                if (exceptionLogger.isErrorEnabled()) {
                    exceptionLogger.error("[C] handle response message failed,rpcId:{},sourceIp:{},reason:{}.", new Object[]{rpcId, conn.getHost(), "Already handled."});
                }
                return;
            }
            ClientInvocation syncInvocation = reqRespWrapper.getInvocation();
            SerializeServiceResponsePacket responsePacket = new SerializeServiceResponsePacket(serializer, syncInvocation.getMethod().getGenericReturnType());
            responsePacket.init(message);
            reqRespWrapper.setResult(new Result(responsePacket.result));
        }
        catch (Exception e) {
            reqRespWrapper.setResult(new Result().setException((Throwable)e));
        }
        finally {
            if (reqRespWrapper != null) {
                reqRespWrapper.getReqRespLatch().countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleForOk(VenusBackendConnection conn, byte[] message, Serializer serializer) {
        VenusReqRespWrapper reqRespWrapper = null;
        try {
            OKPacket okPacket = new OKPacket();
            okPacket.init(message);
            String rpcId = RpcIdUtil.getRpcId((AbstractServicePacket)okPacket);
            reqRespWrapper = this.serviceReqRespMap.get(rpcId);
            if (reqRespWrapper != null) {
                Logger trLogger = tracerLogger;
                if (VenusUtil.isAthenaInterface((Invocation)reqRespWrapper.getInvocation())) {
                    trLogger = logger;
                }
                if (trLogger.isInfoEnabled()) {
                    trLogger.info("[C] recv ok response,rpcId:{},sourceIp:{}.", (Object)rpcId, (Object)conn.getHost());
                }
            }
            if (reqRespWrapper == null) {
                if (exceptionLogger.isErrorEnabled()) {
                    exceptionLogger.error("[C] handle error message failed,rpcId:{},sourceIp:{},reason:{}.", new Object[]{rpcId, conn.getHost(), "Already handled."});
                }
                return;
            }
            reqRespWrapper.setResult(new Result(null));
        }
        catch (Exception e) {
            reqRespWrapper.setResult(new Result().setException((Throwable)e));
        }
        finally {
            if (reqRespWrapper != null) {
                reqRespWrapper.getReqRespLatch().countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleForNotify(VenusBackendConnection conn, byte[] message, Serializer serializer) {
        String rpcId = null;
        ClientInvocation asyncInvocation = null;
        try {
            rpcId = RpcIdUtil.getRpcId((AbstractServicePacket)this.parseServicePacket(message));
            asyncInvocation = this.serviceReqCallbackMap.get(rpcId);
            if (asyncInvocation != null) {
                Logger trLogger = tracerLogger;
                if (VenusUtil.isAthenaInterface((Invocation)asyncInvocation)) {
                    trLogger = logger;
                }
                if (trLogger.isInfoEnabled()) {
                    trLogger.info("[C] recv notify response,rpcId:{},sourceIp:{}.", (Object)rpcId, (Object)conn.getHost());
                }
            }
            if (asyncInvocation == null) {
                if (exceptionLogger.isErrorEnabled()) {
                    exceptionLogger.error("[C] handle notify message failed,rpcId:{},sourceIp:{},reason:{}.", new Object[]{rpcId, conn.getHost(), "Already handled."});
                }
                return;
            }
            ServicePacketBuffer buffer = new ServicePacketBuffer(message);
            buffer.setPosition(28);
            String listenerClass = buffer.readLengthCodedString("utf-8");
            int identityHashCode = buffer.readInt();
            SerializeServiceNofityPacket nofityPacket = new SerializeServiceNofityPacket(serializer, asyncInvocation.getType());
            nofityPacket.init(message);
            if (nofityPacket.errorCode != 0) {
                Throwable t = this.buildExceptionFromNotifyPacket(nofityPacket, serializer, (VenusExceptionFactory)XmlVenusExceptionFactory.getInstance());
                Throwable exception = null;
                exception = t instanceof Exception ? (Exception)t : new RpcException(nofityPacket.errorCode, nofityPacket.errorMessage);
                asyncInvocation.getInvocationListener().onException((Exception)exception);
            } else {
                asyncInvocation.getInvocationListener().callback(nofityPacket.callbackObject);
            }
        }
        catch (Exception e) {
            asyncInvocation.getInvocationListener().onException(e);
        }
        finally {
            if (rpcId != null && this.serviceReqCallbackMap.containsKey(rpcId)) {
                this.serviceReqCallbackMap.remove(rpcId);
            }
        }
    }

    Throwable buildExceptionFromErrorPacket(ErrorPacket errorPacket, Serializer serializer, VenusExceptionFactory venusExceptionFactory) throws Exception {
        if (venusExceptionFactory == null) {
            RpcException rpcException = new RpcException(errorPacket.errorCode, errorPacket.message);
            return rpcException;
        }
        Exception exception = venusExceptionFactory.getException(errorPacket.errorCode, errorPacket.message);
        if (exception == null) {
            exception = new DefaultVenusException(errorPacket.errorCode, errorPacket.message);
        } else if (errorPacket.additionalData != null) {
            Map obj = serializer.decode(errorPacket.additionalData, Utils.getBeanFieldType(exception.getClass(), Exception.class));
            try {
                BeanUtils.copyProperties((Object)exception, (Object)obj);
            }
            catch (Exception e1) {
                exceptionLogger.error("copy properties error", (Throwable)e1);
            }
        }
        return exception;
    }

    Throwable buildExceptionFromNotifyPacket(SerializeServiceNofityPacket nofityPacket, Serializer serializer, VenusExceptionFactory venusExceptionFactory) throws Exception {
        if (venusExceptionFactory == null) {
            RpcException rpcException = new RpcException(nofityPacket.errorCode, nofityPacket.errorMessage);
            return rpcException;
        }
        Exception exception = venusExceptionFactory.getException(nofityPacket.errorCode, nofityPacket.errorMessage);
        if (exception == null) {
            exception = new DefaultVenusException(nofityPacket.errorCode, nofityPacket.errorMessage);
        } else if (nofityPacket.additionalData != null) {
            Map obj = serializer.decode(nofityPacket.additionalData, Utils.getBeanFieldType(exception.getClass(), Exception.class));
            try {
                BeanUtils.copyProperties((Object)exception, (Object)obj);
            }
            catch (Exception e1) {
                exceptionLogger.error("copy properties error", (Throwable)e1);
            }
        }
        return exception;
    }

    AbstractServicePacket parseServicePacket(byte[] message) {
        OKPacket okPacket = new OKPacket();
        okPacket.init(message);
        return okPacket;
    }

    public Map<String, ClientInvocation> getServiceReqCallbackMap() {
        return this.serviceReqCallbackMap;
    }

    public void setServiceReqCallbackMap(Map<String, ClientInvocation> serviceReqCallbackMap) {
        this.serviceReqCallbackMap = serviceReqCallbackMap;
    }

    public Map<String, VenusReqRespWrapper> getServiceReqRespMap() {
        return this.serviceReqRespMap;
    }

    public void setServiceReqRespMap(Map<String, VenusReqRespWrapper> serviceReqRespMap) {
        this.serviceReqRespMap = serviceReqRespMap;
    }
}

