/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.invoker.venus;

import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.util.TimeUtil;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.VenusApplication;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.factory.xml.config.ClientRemoteConfig;
import com.meidusa.venus.client.invoker.AbstractClientInvoker;
import com.meidusa.venus.client.invoker.venus.VenusClientConnectionFactory;
import com.meidusa.venus.client.invoker.venus.VenusReqRespWrapper;
import com.meidusa.venus.exception.InvalidParameterException;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.metainfo.EndpointParameter;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.support.EndpointWrapper;
import com.meidusa.venus.support.ServiceWrapper;
import com.meidusa.venus.support.VenusThreadContext;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class VenusClientInvoker
extends AbstractClientInvoker
implements Invoker {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger tracerLogger = VenusLoggerFactory.getTracerLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private byte serializeType = 0;
    private ClientRemoteConfig remoteConfig;
    private VenusClientConnectionFactory venusClientConnectionFactory = new VenusClientConnectionFactory();
    private static Map<String, VenusReqRespWrapper> serviceReqRespMap = new ConcurrentHashMap<String, VenusReqRespWrapper>();
    private static Map<String, ClientInvocation> serviceReqCallbackMap = new ConcurrentHashMap<String, ClientInvocation>();

    public VenusClientInvoker() {
        this.venusClientConnectionFactory.setServiceReqRespMap(serviceReqRespMap);
        this.venusClientConnectionFactory.setServiceReqCallbackMap(serviceReqCallbackMap);
        VenusApplication.addInvoker((Invoker)this);
    }

    public void init() throws RpcException {
    }

    @Override
    public Result doInvoke(ClientInvocation invocation, URL url) throws RpcException {
        if (!this.isCallbackInvocation(invocation)) {
            return this.doInvokeWithSync(invocation, url);
        }
        return this.doInvokeWithCallback(invocation, url);
    }

    boolean isCallbackInvocation(ClientInvocation invocation) {
        EndpointParameter[] params = invocation.getParams();
        if (params != null) {
            Object[] args = invocation.getArgs();
            for (int i = 0; i < params.length; ++i) {
                if (!(args[i] instanceof InvocationListener)) continue;
                return true;
            }
        }
        return false;
    }

    public Result doInvokeWithSync(ClientInvocation invocation, URL url) throws RpcException {
        Result result = null;
        int timeout = invocation.getTimeout();
        SerializeServiceRequestPacket request = this.buildRequest(invocation);
        String rpcId = invocation.getRpcId();
        VenusReqRespWrapper reqRespWrapper = new VenusReqRespWrapper(invocation);
        serviceReqRespMap.put(rpcId, reqRespWrapper);
        this.sendRequest(invocation, request, url, reqRespWrapper);
        boolean isAwaitException = false;
        try {
            reqRespWrapper.getReqRespLatch().await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            isAwaitException = true;
            throw new RpcException((Throwable)e);
        }
        finally {
            if (isAwaitException && serviceReqRespMap.get(rpcId) != null) {
                serviceReqRespMap.remove(rpcId);
            }
        }
        result = this.fetchResponse(rpcId);
        if (result == null) {
            throw new RpcException(400, String.format("invoke api:%s,service:%s timeout,timeout:%dms", invocation.getApiName(), url.getPath(), timeout));
        }
        return result;
    }

    public Result doInvokeWithCallback(ClientInvocation invocation, URL url) throws RpcException {
        SerializeServiceRequestPacket request = this.buildRequest(invocation);
        serviceReqCallbackMap.put(invocation.getRpcId(), invocation);
        this.sendRequest(invocation, request, url, null);
        return new Result(null);
    }

    SerializeServiceRequestPacket buildRequest(ClientInvocation invocation) {
        Method method = invocation.getMethod();
        ServiceWrapper service = invocation.getService();
        EndpointWrapper endpoint = invocation.getEndpoint();
        EndpointParameter[] params = invocation.getParams();
        Object[] args = invocation.getArgs();
        Serializer serializer = SerializerFactory.getSerializer((short)this.serializeType);
        SerializeServiceRequestPacket serviceRequestPacket = new SerializeServiceRequestPacket(serializer, null);
        serviceRequestPacket.clientId = invocation.getClientId();
        serviceRequestPacket.clientRequestId = invocation.getClientRequestId();
        serviceRequestPacket.traceId = invocation.getTraceID();
        if (invocation.getAthenaId() != null) {
            serviceRequestPacket.rootId = invocation.getAthenaId();
        }
        if (invocation.getParentId() != null) {
            serviceRequestPacket.parentId = invocation.getParentId();
        }
        if (invocation.getMessageId() != null) {
            serviceRequestPacket.messageId = invocation.getMessageId();
        }
        serviceRequestPacket.apiName = VenusUtil.getApiName((Method)method, (ServiceWrapper)service, (EndpointWrapper)endpoint);
        serviceRequestPacket.serviceVersion = service.getVersion();
        serviceRequestPacket.parameterMap = new HashMap();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (args[i] instanceof InvocationListener) {
                    ReferenceInvocationListener listener = new ReferenceInvocationListener();
                    ServicePacketBuffer buffer = new ServicePacketBuffer(16);
                    buffer.writeLengthCodedString(args[i].getClass().getName(), "utf-8");
                    buffer.writeInt(System.identityHashCode(args[i]));
                    listener.setIdentityData(buffer.toByteBuffer().array());
                    Type type = method.getGenericParameterTypes()[i];
                    if (!(type instanceof ParameterizedType)) {
                        throw new InvalidParameterException("invocationListener is not generic");
                    }
                    ParameterizedType genericType = (ParameterizedType)type;
                    invocation.setInvocationListener((InvocationListener)args[i]);
                    invocation.setType(genericType.getActualTypeArguments()[0]);
                    serviceRequestPacket.parameterMap.put(params[i].getParamName(), listener);
                    continue;
                }
                serviceRequestPacket.parameterMap.put(params[i].getParamName(), args[i]);
            }
        }
        return serviceRequestPacket;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendRequest(ClientInvocation invocation, SerializeServiceRequestPacket serviceRequestPacket, URL url, VenusReqRespWrapper reqRespWrapper) throws RpcException {
        Throwable exception;
        String rpcId;
        long borrowed;
        long start;
        block16: {
            BackendConnection conn;
            BackendConnectionPool nioConnPool;
            block15: {
                borrowed = start = TimeUtil.currentTimeMillis();
                nioConnPool = null;
                conn = null;
                rpcId = invocation.getRpcId();
                exception = null;
                try {
                    VenusClientConnectionFactory.BackendConnectionWrapper connectionWrapper = this.venusClientConnectionFactory.getConnection(url, invocation, this.remoteConfig);
                    nioConnPool = connectionWrapper.getBackendConnectionPool();
                    conn = connectionWrapper.getBackendConnection();
                    borrowed = System.currentTimeMillis();
                    if (reqRespWrapper != null) {
                        reqRespWrapper.setBackendConnection(conn);
                    }
                    if (conn == null || nioConnPool == null) break block15;
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (conn == null) throw throwable;
                        if (nioConnPool == null) throw throwable;
                        nioConnPool.returnObject(conn);
                        throw throwable;
                    }
                }
                nioConnPool.returnObject(conn);
            }
            try {
                ByteBuffer buffer = serviceRequestPacket.toByteBuffer();
                VenusThreadContext.set((String)"clientOutputSize", (Object)buffer.limit());
                conn.write(buffer);
                if (conn == null || nioConnPool == null) break block16;
            }
            catch (RpcException e) {
                try {
                    exception = e;
                    throw e;
                    catch (Throwable e2) {
                        exception = e2;
                        throw new RpcException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (conn != null && nioConnPool != null) {
                        nioConnPool.returnObject(conn);
                    }
                    long connTime = borrowed - start;
                    long totalTime = System.currentTimeMillis() - start;
                    Logger trLogger = tracerLogger;
                    if (VenusUtil.isAthenaInterface((Invocation)invocation)) {
                        trLogger = logger;
                    }
                    if (exception != null) {
                        if (!trLogger.isErrorEnabled()) throw throwable;
                        String tpl = "[C] [failed,{}] send request failed,rpcId:{},api:{},method:{},targetIp:{},exception:{}.";
                        Object[] arguments = new Object[]{totalTime + "ms," + connTime + "ms", rpcId, invocation.getApiName(), invocation.getMethodPath(), url.getHost(), exception};
                        trLogger.error(tpl, arguments);
                        exceptionLogger.error(tpl, arguments);
                        throw throwable;
                    }
                    if (!trLogger.isInfoEnabled()) throw throwable;
                    String tpl = "[C] [{}] send request,rpcId:{},api:{},method:{},targetIp:{}.";
                    Object[] arguments = new Object[]{totalTime + "ms," + connTime + "ms", rpcId, invocation.getApiName(), invocation.getMethodPath(), url.getHost()};
                    trLogger.info(tpl, arguments);
                    throw throwable;
                }
            }
            nioConnPool.returnObject(conn);
        }
        long connTime = borrowed - start;
        long totalTime = System.currentTimeMillis() - start;
        Logger trLogger = tracerLogger;
        if (VenusUtil.isAthenaInterface((Invocation)invocation)) {
            trLogger = logger;
        }
        if (exception != null) {
            if (!trLogger.isErrorEnabled()) return;
            String tpl = "[C] [failed,{}] send request failed,rpcId:{},api:{},method:{},targetIp:{},exception:{}.";
            Object[] arguments = new Object[]{totalTime + "ms," + connTime + "ms", rpcId, invocation.getApiName(), invocation.getMethodPath(), url.getHost(), exception};
            trLogger.error(tpl, arguments);
            exceptionLogger.error(tpl, arguments);
            return;
        }
        if (!trLogger.isInfoEnabled()) return;
        String tpl = "[C] [{}] send request,rpcId:{},api:{},method:{},targetIp:{}.";
        Object[] arguments = new Object[]{totalTime + "ms," + connTime + "ms", rpcId, invocation.getApiName(), invocation.getMethodPath(), url.getHost()};
        trLogger.info(tpl, arguments);
    }

    Result fetchResponse(String rpcId) {
        VenusReqRespWrapper reqRespWrapper = serviceReqRespMap.get(rpcId);
        if (reqRespWrapper == null) {
            return null;
        }
        Result result = reqRespWrapper.getResult();
        if (result == null) {
            serviceReqRespMap.remove(rpcId);
            return null;
        }
        serviceReqRespMap.remove(rpcId);
        return result;
    }

    public short getSerializeType() {
        return this.serializeType;
    }

    public void setSerializeType(byte serializeType) {
        this.serializeType = serializeType;
    }

    public ClientRemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public void setRemoteConfig(ClientRemoteConfig remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public void destroy() throws RpcException {
        if (logger.isInfoEnabled()) {
            logger.info("destroy invoker:{}.", (Object)this);
        }
        this.venusClientConnectionFactory.destroy();
    }
}

