/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.invoker.venus;

import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionObserver;
import com.meidusa.venus.ConnectionFactory;
import com.meidusa.venus.support.VenusContext;
import com.meidusa.venus.util.VenusLoggerFactory;
import org.slf4j.Logger;

public class VenusClientConnectionObserver
implements ConnectionObserver {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();

    public void connectionEstablished(Connection conn) {
        if (logger.isInfoEnabled()) {
            if (conn != null && conn instanceof BackendConnection) {
                logger.info("connection established,target:[{}].", (Object)this.getTargetAddress((BackendConnection)conn));
            } else {
                logger.info("connection established,conn:{}.", (Object)conn);
            }
        }
    }

    public void connectionFailed(Connection conn, Exception fault) {
        if (exceptionLogger.isErrorEnabled()) {
            if (conn != null && conn instanceof BackendConnection) {
                exceptionLogger.error("connection failed,target:[{}],fault:{}.", (Object)this.getTargetAddress((BackendConnection)conn), (Object)fault);
            } else {
                exceptionLogger.error("connection failed,conn:{},fault:{}.", (Object)conn, (Object)fault);
            }
        }
    }

    public void connectionClosed(Connection conn) {
        if (logger.isWarnEnabled()) {
            if (conn != null && conn instanceof BackendConnection) {
                String ipAddress = this.getTargetAddress((BackendConnection)conn);
                logger.warn("connection closed,target:[{}].", (Object)ipAddress);
            } else {
                logger.warn("connection closed,conn:{}.", (Object)conn);
            }
        }
        try {
            VenusContext context;
            ConnectionFactory connectionFactory;
            if (conn != null && (connectionFactory = (context = VenusContext.getInstance()).getConnectionFactory()) != null) {
                connectionFactory.releaseConnection(conn);
            }
        }
        catch (Exception e) {
            exceptionLogger.error("#########release conn rela resource failed.", (Throwable)e);
        }
    }

    String getTargetAddress(BackendConnection backendConnection) {
        StringBuilder builder = new StringBuilder();
        builder.append(backendConnection.getHost());
        builder.append(":");
        builder.append(backendConnection.getPort());
        return builder.toString();
    }
}

