/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.invoker.venus;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.common.heartbeat.Status;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionConnector;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.ConnectionObserver;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.factory.BackendConnectionFactory;
import com.meidusa.venus.ConnectionFactory;
import com.meidusa.venus.URL;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.factory.xml.config.ClientRemoteConfig;
import com.meidusa.venus.client.factory.xml.config.FactoryConfig;
import com.meidusa.venus.client.factory.xml.config.PoolConfig;
import com.meidusa.venus.client.invoker.venus.VenusClientConnectionObserver;
import com.meidusa.venus.client.invoker.venus.VenusClientInvokerMessageHandler;
import com.meidusa.venus.client.invoker.venus.VenusReqRespWrapper;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.io.network.Venus4BackendConnectionFactory;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.VenusStatusRequestPacket;
import com.meidusa.venus.io.packet.VenusStatusResponsePacket;
import com.meidusa.venus.support.VenusContext;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusClientConnectionFactory
implements ConnectionFactory {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static ConnectionConnector connector;
    private static ConnectionManager[] connectionManagers;
    private static Map<String, BackendConnectionPool> connectionPoolMap;
    private Map<String, VenusReqRespWrapper> serviceReqRespMap;
    private Map<String, ClientInvocation> serviceReqCallbackMap;

    public VenusClientConnectionFactory() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        VenusClientConnectionFactory venusClientConnectionFactory = this;
        synchronized (venusClientConnectionFactory) {
            if (connector == null && connectionManagers == null) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info("#########init connector#############");
                    }
                    connector = new ConnectionConnector("connection connector-0");
                    int ioThreads = Runtime.getRuntime().availableProcessors();
                    connectionManagers = new ConnectionManager[ioThreads];
                    for (int i = 0; i < ioThreads; ++i) {
                        ConnectionManager connManager = new ConnectionManager("connection manager-" + i, -1);
                        connManager.addConnectionObserver((ConnectionObserver)new VenusClientConnectionObserver());
                        VenusClientConnectionFactory.connectionManagers[i] = connManager;
                        connManager.start();
                    }
                    connector.setProcessors(connectionManagers);
                    connector.start();
                }
                catch (IOException e) {
                    throw new RpcException((Throwable)e);
                }
            }
            VenusContext.getInstance().setConnectionFactory((ConnectionFactory)this);
        }
    }

    BackendConnectionWrapper getConnection(URL url, ClientInvocation invocation, ClientRemoteConfig remoteConfig) {
        BackendConnectionPool nioConnPool = null;
        BackendConnection conn = null;
        try {
            nioConnPool = this.getNioConnPool(url, invocation, null);
            conn = nioConnPool.borrowObject();
            if (conn != null && conn.isClosed()) {
                String address = url.getHost() + ":" + url.getPort();
                throw new RpcException(300, String.format("get connection:%s failed,conn is closed.", address));
            }
            return new BackendConnectionWrapper(conn, nioConnPool);
        }
        catch (Exception e) {
            if (e instanceof RpcException) {
                throw (RpcException)((Object)e);
            }
            String address = url.getHost() + ":" + url.getHost();
            throw new RpcException(300, String.format("get connection:%s failed,exception:%s", address, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendConnectionPool getNioConnPool(URL url, ClientInvocation invocation, ClientRemoteConfig remoteConfig) {
        String address = url.getHost() + ":" + url.getPort();
        if (connectionPoolMap.get(address) != null) {
            BackendConnectionPool connectionPool = connectionPoolMap.get(address);
            if (connectionPool.isValid()) {
                if (!connectionPool.isClosed()) {
                    return connectionPool;
                }
            } else if (!connectionPool.isClosed()) {
                connectionPool.close();
                connectionPoolMap.remove(address);
            }
        }
        Map<String, BackendConnectionPool> map = connectionPoolMap;
        synchronized (map) {
            if (connectionPoolMap.get(address) != null) {
                BackendConnectionPool connectionPool = connectionPoolMap.get(address);
                if (connectionPool.isValid() && !connectionPool.isClosed()) {
                    return connectionPool;
                }
                throw new RpcException(300, "connection pool invalid or closed.");
            }
            BackendConnectionPool connectionPool = this.createNioConnPool(url, invocation, new ClientRemoteConfig());
            connectionPoolMap.put(address, connectionPool);
            return connectionPool;
        }
    }

    private BackendConnectionPool createNioConnPool(URL url, ClientInvocation invocation, ClientRemoteConfig remoteConfig) {
        FactoryConfig factoryConfig;
        String address = url.getHost() + ":" + url.getPort();
        if (logger.isInfoEnabled()) {
            logger.info("#########create nio pool:[{}]#############", (Object)address);
        }
        Venus4BackendConnectionFactory nioFactory = new Venus4BackendConnectionFactory();
        nioFactory.setHost(url.getHost());
        nioFactory.setPort(Integer.valueOf(url.getPort()).intValue());
        if (remoteConfig.getAuthenticator() != null) {
            nioFactory.setAuthenticator(remoteConfig.getAuthenticator());
        }
        if ((factoryConfig = remoteConfig.getFactory()) != null) {
            // empty if block
        }
        nioFactory.setConnector(connector);
        VenusClientInvokerMessageHandler messageHandler = new VenusClientInvokerMessageHandler();
        messageHandler.setServiceReqRespMap(this.serviceReqRespMap);
        messageHandler.setServiceReqCallbackMap(this.serviceReqCallbackMap);
        nioFactory.setMessageHandler((MessageHandler)messageHandler);
        int connectionCount = invocation.getCoreConnections();
        Venus4BackendConnectionPool nioPool = new Venus4BackendConnectionPool(this, "N-" + url.getHost(), (BackendConnectionFactory)nioFactory, connectionCount);
        PoolConfig poolConfig = remoteConfig.getPool();
        if (poolConfig != null) {
            // empty if block
        }
        try {
            nioPool.init();
            if (!nioPool.isValid()) {
                if (!nioPool.isClosed()) {
                    nioPool.close();
                }
                throw new RpcException(300, "create connection pool invalid:" + address);
            }
        }
        catch (Exception e) {
            if (e instanceof RpcException) {
                throw (RpcException)((Object)e);
            }
            if (nioPool != null && !nioPool.isClosed()) {
                nioPool.close();
            }
            throw new RpcException(300, "init connection pool failed:" + address);
        }
        return nioPool;
    }

    public void releaseConnection(Connection conn) {
        if (conn != null && conn instanceof BackendConnection) {
            BackendConnection backendConnection = (BackendConnection)conn;
            this.releaseCountDownLatch(conn);
            String address = backendConnection.getHost() + ":" + backendConnection.getPort();
            BackendConnectionPool connectionPool = connectionPoolMap.get(address);
            if (connectionPool != null && !connectionPool.isValid()) {
                this.releaseNioConnPool(address);
            }
        }
    }

    public void releaseConnection(String address) {
        BackendConnectionPool connectionPool = connectionPoolMap.get(address);
        if (connectionPool != null && !connectionPool.isValid()) {
            this.releaseNioConnPool(address);
        }
    }

    void releaseNioConnPool(String address) {
        BackendConnectionPool connectionPool = connectionPoolMap.get(address);
        if (connectionPool == null || connectionPool.isClosed()) {
            return;
        }
        try {
            logger.info("connection pool:[{}] is invalid,release connection pool.", (Object)address);
            connectionPool.close();
            connectionPoolMap.remove(address);
        }
        catch (Exception e) {
            exceptionLogger.error("close connection pool failed:" + address, (Throwable)e);
        }
    }

    void releaseCountDownLatch(Connection conn) {
        block5: {
            try {
                if (MapUtils.isEmpty(this.serviceReqRespMap)) {
                    return;
                }
                Collection<VenusReqRespWrapper> reqRespWrapperCollection = this.serviceReqRespMap.values();
                for (VenusReqRespWrapper reqRespWrapper : reqRespWrapperCollection) {
                    if (conn != reqRespWrapper.getBackendConnection() || reqRespWrapper.getReqRespLatch() == null || reqRespWrapper.getReqRespLatch().getCount() <= 0L) continue;
                    if (logger.isWarnEnabled()) {
                        logger.warn("release latch:{}.", (Object)reqRespWrapper.getReqRespLatch());
                    }
                    reqRespWrapper.getReqRespLatch().countDown();
                }
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) break block5;
                exceptionLogger.error("release countDown latch error.", (Throwable)e);
            }
        }
    }

    public Map<String, VenusReqRespWrapper> getServiceReqRespMap() {
        return this.serviceReqRespMap;
    }

    public void setServiceReqRespMap(Map<String, VenusReqRespWrapper> serviceReqRespMap) {
        this.serviceReqRespMap = serviceReqRespMap;
    }

    public Map<String, ClientInvocation> getServiceReqCallbackMap() {
        return this.serviceReqCallbackMap;
    }

    public void setServiceReqCallbackMap(Map<String, ClientInvocation> serviceReqCallbackMap) {
        this.serviceReqCallbackMap = serviceReqCallbackMap;
    }

    public void destroy() {
        if (connector != null && connector.isAlive()) {
            connector.shutdown();
        }
        if (connectionManagers != null && connectionManagers.length > 0) {
            for (ConnectionManager connManager : connectionManagers) {
                if (connManager == null || !connManager.isAlive()) continue;
                connManager.shutdown();
            }
        }
    }

    static {
        connectionPoolMap = new ConcurrentHashMap<String, BackendConnectionPool>();
    }

    class ConnectionPoolHeartbeatHandler<T>
    implements MessageHandler<BackendConnection, T> {
        private CountDownLatch latch = new CountDownLatch(1);
        private Status status;

        ConnectionPoolHeartbeatHandler() {
        }

        protected void setStatus(Status status) {
            this.status = status;
            this.latch.countDown();
        }

        public void sendMsg(BackendConnection conn) {
            VenusStatusRequestPacket packet = new VenusStatusRequestPacket();
            conn.write(packet.toByteBuffer());
        }

        protected Status getResult(BackendConnection conn) {
            try {
                this.latch.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.status;
        }

        public void handle(BackendConnection conn, T data) {
            byte[] message = (byte[])data;
            int type = AbstractServicePacket.getType((byte[])message);
            if (type == 0x1000002) {
                this.setStatus(Status.VALID);
            } else if (type == 0x5000002) {
                VenusStatusResponsePacket packet = new VenusStatusResponsePacket();
                packet.init(message);
                if ((packet.status & 4) > 0) {
                    this.setStatus(Status.OUT_OF_MEMORY);
                } else if ((packet.status & 2) > 0) {
                    this.setStatus(Status.INVALID);
                } else {
                    this.setStatus(Status.VALID);
                }
            }
        }
    }

    class ConnectionPoolHeartbeatChecker
    extends BackendConnectionPool.ObjectPoolHeartbeatDelayed {
        Status last;
        private BackendConnectionFactory factory;
        private BackendConnection idleConn;
        private ConnectionPoolHeartbeatHandler idleHandler;
        private int size;

        public ConnectionPoolHeartbeatChecker(long nsTime, TimeUnit timeUnit, BackendConnectionPool pool, BackendConnectionFactory factory, int size) {
            super(nsTime, timeUnit, pool);
            this.last = Status.VALID;
            this.factory = factory;
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Status doCheck() {
            Status status = null;
            try {
                status = this.doCheckEx();
                if (this.last == Status.INVALID && status == Status.VALID) {
                    for (int i = 0; i < this.size; ++i) {
                        status = this.doCheckEx();
                        if (status != Status.INVALID) continue;
                        Status status2 = status;
                        return status2;
                    }
                    Status i = status;
                    return i;
                }
                Status i = status;
                return i;
            }
            catch (Exception ex) {
                Status status3 = Status.INVALID;
                return status3;
            }
            finally {
                this.last = status;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Status doCheckEx() {
            BackendConnection conn = null;
            try {
                conn = this.pool.borrowObject();
                if (conn != null) {
                    if (conn.isClosed()) {
                        this.pool.setValid(false);
                        Status status = Status.INVALID;
                        return status;
                    }
                    this.pool.setValid(true);
                    Status status = Status.VALID;
                    return status;
                }
                Status status = Status.INVALID;
                return status;
            }
            catch (Exception e) {
                logger.warn("connection pool check error.", (Throwable)e);
                this.pool.setValid(false);
                Status status = Status.INVALID;
                return status;
            }
            finally {
                if (conn != null) {
                    this.pool.returnObject(conn);
                }
            }
        }

        Status doHeartbeatCheck() throws Exception {
            if (this.idleConn == null || this.idleConn.isClosed()) {
                this.idleConn = this.factory.make();
                this.idleHandler = new ConnectionPoolHeartbeatHandler();
                this.idleConn.setHandler((MessageHandler)this.idleHandler);
            }
            this.idleHandler.sendMsg(this.idleConn);
            Status status = this.idleHandler.getResult(this.idleConn);
            if (status == Status.VALID) {
                this.pool.setValid(true);
                return Status.VALID;
            }
            this.pool.setValid(false);
            return status;
        }

        public boolean isCycle() {
            return true;
        }
    }

    class Venus4BackendConnectionPool<F extends BackendConnectionFactory, V extends BackendConnection>
    implements BackendConnectionPool {
        private final Logger LOGGER = LoggerFactory.getLogger(Venus4BackendConnectionPool.class);
        private int HEATBEAT_INTERVAL = Integer.getInteger("heartbeat.interval", HeartbeatManager.DEFAULT_HEATBEAT_INTERVAL);
        private volatile long currentCounter = 0L;
        private final F factory;
        private final int size;
        private final BackendConnection[] items;
        private String name;
        private boolean valid = true;
        private boolean closed = false;
        private ConnectionPoolHeartbeatChecker heartbeatChecker;
        private final Map<Integer, Object> lockMap = new HashMap<Integer, Object>();
        final /* synthetic */ VenusClientConnectionFactory this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public Venus4BackendConnectionPool(String name, F factory, int size) {
            this.this$0 = (VenusClientConnectionFactory)this$0;
            this.size = size;
            this.items = new BackendConnection[size];
            this.factory = factory;
            this.name = name;
        }

        public void init() {
            int i;
            for (i = 0; i < this.items.length; ++i) {
                this.lockMap.put(i, new Object());
            }
            for (i = 0; i < this.items.length; ++i) {
                try {
                    this.items[i] = this.factory.make();
                    continue;
                }
                catch (IOException e) {
                    this.LOGGER.error("init pool error ,name=" + this.name, (Throwable)e);
                    this.setValid(false);
                    break;
                }
            }
            this.heartbeatChecker = this.this$0.new ConnectionPoolHeartbeatChecker(this.HEATBEAT_INTERVAL, TimeUnit.SECONDS, this, (BackendConnectionFactory)this.factory, this.size);
            HeartbeatManager.addHeartbeat((HeartbeatDelayed)this.heartbeatChecker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BackendConnection borrowObject() throws Exception {
            BackendConnection conn = null;
            for (int j = 0; j < this.size + 1; ++j) {
                int i;
                if ((conn = this.items[i = (int)(this.currentCounter++ % (long)this.size)]) == null) {
                    Object lockObject;
                    Object object = lockObject = this.lockMap.get(i);
                    synchronized (object) {
                        conn = this.items[i];
                        if (conn == null) {
                            conn = this.items[i] = this.factory.make();
                            conn.setPool((BackendConnectionPool)this);
                        }
                    }
                }
                if (!conn.isClosed()) {
                    conn.setActive(true);
                    return conn;
                }
                this.items[i] = null;
            }
            this.setValid(false);
            throw new InvalidObjectException("invalid pool=" + this.name);
        }

        public void returnObject(BackendConnection c) {
            c.setActive(false);
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.heartbeatChecker != null) {
                HeartbeatManager.removeHeartbeat((HeartbeatDelayed)this.heartbeatChecker);
            }
            for (BackendConnection conn : this.items) {
                if (conn == null || conn.isClosed()) continue;
                conn.close();
            }
        }

        public String getName() {
            return this.name;
        }

        public int getActive() {
            return this.items.length;
        }

        public void deActive(BackendConnection c) {
            c.setActive(false);
        }

        public boolean isValid() {
            if (this.items == null || this.items.length == 0) {
                return false;
            }
            for (BackendConnection item : this.items) {
                if (item == null || item.isClosed()) continue;
                return true;
            }
            return false;
        }

        public void setValid(boolean b) {
            this.valid = b;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    class BackendConnectionWrapper {
        private BackendConnection backendConnection;
        private BackendConnectionPool backendConnectionPool;

        public BackendConnectionWrapper(BackendConnection backendConnection, BackendConnectionPool backendConnectionPool) {
            this.backendConnection = backendConnection;
            this.backendConnectionPool = backendConnectionPool;
        }

        public BackendConnection getBackendConnection() {
            return this.backendConnection;
        }

        public void setBackendConnection(BackendConnection backendConnection) {
            this.backendConnection = backendConnection;
        }

        public BackendConnectionPool getBackendConnectionPool() {
            return this.backendConnectionPool;
        }

        public void setBackendConnectionPool(BackendConnectionPool backendConnectionPool) {
            this.backendConnectionPool = backendConnectionPool;
        }
    }
}

