/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.invoker;

import com.meidusa.venus.ClusterInvoker;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.RemoteConfig;
import com.meidusa.venus.Result;
import com.meidusa.venus.ServiceDefinitionExtra;
import com.meidusa.venus.URL;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.cluster.ClusterFailoverInvoker;
import com.meidusa.venus.client.cluster.ClusterFastfailInvoker;
import com.meidusa.venus.client.factory.xml.config.ClientRemoteConfig;
import com.meidusa.venus.client.invoker.venus.VenusClientInvoker;
import com.meidusa.venus.client.router.Router;
import com.meidusa.venus.client.router.condition.ConditionRuleRouter;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.registry.Register;
import com.meidusa.venus.registry.domain.VenusServiceDefinitionDO;
import com.meidusa.venus.util.JSONUtil;
import com.meidusa.venus.util.Range;
import com.meidusa.venus.util.RangeUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ClientRemoteInvoker
implements Invoker {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private ClientRemoteConfig remoteConfig;
    private List<URL> cacheUrlList;
    private Register register;
    private Router router = new ConditionRuleRouter();
    private VenusClientInvoker invoker = new VenusClientInvoker();
    private ClusterFailoverInvoker clusterFailoverInvoker = new ClusterFailoverInvoker(this.invoker);
    private ClusterFastfailInvoker clusterFastfailInvoker = new ClusterFastfailInvoker(this.invoker);

    public void init() throws RpcException {
    }

    public Result invoke(Invocation invocation, URL url) throws RpcException {
        if (this.isRegisterLookup()) {
            return this.invokeByRegisterLookup(invocation, url);
        }
        return this.invokeByStaticLookup(invocation, url);
    }

    Result invokeByStaticLookup(Invocation invocation, URL url) throws RpcException {
        ClientInvocation clientInvocation = (ClientInvocation)invocation;
        List<URL> urlList = this.lookupByStatic(clientInvocation);
        Result result = this.getClusterInvoker(clientInvocation, url).invoke(invocation, urlList);
        return result;
    }

    Result invokeByRegisterLookup(Invocation invocation, URL url) throws RpcException {
        ClientInvocation clientInvocation = (ClientInvocation)invocation;
        List<URL> urlList = this.lookupByRegister(clientInvocation);
        urlList = this.router.filte((Invocation)clientInvocation, urlList);
        Result result = this.getClusterInvoker(clientInvocation, url).invoke(invocation, urlList);
        return result;
    }

    boolean isRegisterLookup() {
        if (this.remoteConfig != null) {
            return false;
        }
        if (this.register != null) {
            return true;
        }
        throw new VenusConfigException("remoteConfig and registerUrl not allow empty.");
    }

    List<URL> lookupByStatic(ClientInvocation invocation) {
        ArrayList<URL> urlList = new ArrayList();
        if (this.cacheUrlList == null) {
            String[] addressArr;
            String ipAddressList = this.remoteConfig.getFactory().getIpAddressList();
            for (String address : addressArr = ipAddressList.split(";")) {
                String[] arr = address.split(":");
                URL url = new URL();
                url.setHost(arr[0]);
                url.setPort(Integer.parseInt(arr[1]));
                url.setRemoteConfig((RemoteConfig)this.remoteConfig);
                urlList.add(url);
            }
            this.cacheUrlList = urlList;
        } else {
            urlList = this.cacheUrlList;
        }
        if (CollectionUtils.isEmpty(urlList)) {
            throw new RpcException("not found avalid service providers.");
        }
        if (logger.isDebugEnabled()) {
            ArrayList<String> targets = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty(urlList)) {
                for (URL url : urlList) {
                    String target = url.getHost() + ":" + url.getPort();
                    targets.add(target);
                }
            }
            logger.debug("static lookup service providers num:{},providers:{}.", (Object)targets.size(), (Object)JSONUtil.toJSONString(targets));
        }
        return urlList;
    }

    List<URL> lookupByRegister(ClientInvocation invocation) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        int currentVersion = Integer.parseInt(invocation.getVersion());
        URL requestUrl = this.parseRequestUrl(invocation);
        List srvDefList = this.getRegister().lookup(requestUrl);
        if (CollectionUtils.isEmpty((Collection)srvDefList)) {
            throw new RpcException(String.format("not found available service providers,service:%s", requestUrl.getPath()));
        }
        for (VenusServiceDefinitionDO srvDef : srvDefList) {
            if (CollectionUtils.isEmpty((Collection)srvDef.getIpAddress()) || !this.isAllowVersion(srvDef, currentVersion)) continue;
            for (String addresss : srvDef.getIpAddress()) {
                String[] arr = addresss.split(":");
                URL url = new URL();
                url.setHost(arr[0]);
                url.setPort(Integer.parseInt(arr[1]));
                url.setServiceDefinition((ServiceDefinitionExtra)srvDef);
                if (StringUtils.isNotEmpty((String)srvDef.getProvider())) {
                    url.setApplication(srvDef.getProvider());
                }
                urlList.add(url);
            }
        }
        if (CollectionUtils.isEmpty(urlList)) {
            throw new RpcException("with filter,not found allowed service providers,service:" + requestUrl.toString());
        }
        if (logger.isDebugEnabled()) {
            ArrayList<String> targets = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty(urlList)) {
                for (URL url : urlList) {
                    String target = url.getHost() + ":" + url.getPort();
                    targets.add(target);
                }
            }
            logger.debug("lookup service providers num:{},providers:{}.", (Object)targets.size(), (Object)JSONUtil.toJSONString(targets));
        }
        return urlList;
    }

    boolean isAllowVersion(VenusServiceDefinitionDO srvDef, int currentVersion) {
        String versionRange = srvDef.getVersionRange();
        if (StringUtils.isEmpty((String)versionRange)) {
            return true;
        }
        Range supportVersioRange = RangeUtil.getVersionRange((String)versionRange);
        return supportVersioRange.contains(currentVersion);
    }

    URL parseRequestUrl(ClientInvocation invocation) {
        String serviceInterfaceName = invocation.getServiceInterface().getName();
        String serviceName = invocation.getServiceName();
        StringBuilder buf = new StringBuilder();
        buf.append("/").append(serviceInterfaceName);
        buf.append("/").append(serviceName);
        buf.append("?");
        String serviceUrl = buf.toString();
        URL url = URL.parse((String)serviceUrl);
        return url;
    }

    ClusterInvoker getClusterInvoker(ClientInvocation invocation, URL url) {
        String cluster = invocation.getCluster();
        if ("failover".equals(cluster) || invocation.getRetries() > 0) {
            return this.clusterFailoverInvoker;
        }
        if ("fastfail".equals(cluster)) {
            return this.clusterFastfailInvoker;
        }
        throw new RpcException(String.format("invalid cluster policy:%s.", cluster));
    }

    public void destroy() throws RpcException {
    }

    public ClientRemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public void setRemoteConfig(ClientRemoteConfig remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public Register getRegister() {
        return this.register;
    }

    public void setRegister(Register register) {
        this.register = register;
    }
}

