/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.invoker;

import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.VenusApplication;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.factory.xml.config.ClientRemoteConfig;
import com.meidusa.venus.client.filter.limit.ClientActivesLimitFilter;
import com.meidusa.venus.client.filter.limit.ClientTpsLimitFilter;
import com.meidusa.venus.client.filter.mock.ClientCallbackMockFilter;
import com.meidusa.venus.client.filter.mock.ClientReturnMockFilter;
import com.meidusa.venus.client.filter.mock.ClientThrowMockFilter;
import com.meidusa.venus.client.filter.valid.ClientValidFilter;
import com.meidusa.venus.client.invoker.ClientLocalInvoker;
import com.meidusa.venus.client.invoker.ClientRemoteInvoker;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.monitor.VenusMonitorFactory;
import com.meidusa.venus.monitor.athena.filter.ClientAthenaMonitorFilter;
import com.meidusa.venus.monitor.filter.ClientVenusMonitorFilter;
import com.meidusa.venus.registry.Register;
import com.meidusa.venus.support.EndpointWrapper;
import com.meidusa.venus.support.ServiceWrapper;
import com.meidusa.venus.support.VenusThreadContext;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ClientInvokerProxy
implements Invoker {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private ClientRemoteConfig remoteConfig;
    private Register register;
    private ClientLocalInvoker injvmInvoker = new ClientLocalInvoker();
    private ClientRemoteInvoker clientRemoteInvoker = new ClientRemoteInvoker();
    private List<Filter> beforeFilters = new ArrayList<Filter>();
    private List<Filter> throwFilters = new ArrayList<Filter>();
    private List<Filter> afterFilters = new ArrayList<Filter>();
    private ClientValidFilter clientValidFilter = new ClientValidFilter();
    private ClientActivesLimitFilter clientActivesLimitFilter = new ClientActivesLimitFilter();
    private ClientTpsLimitFilter clientTpsLimitFilter = new ClientTpsLimitFilter();
    private ClientReturnMockFilter clientReturnMockFilter = new ClientReturnMockFilter();
    private ClientThrowMockFilter clientThrowMockFilter = new ClientThrowMockFilter();
    private ClientCallbackMockFilter clientCallbackMockFilter = new ClientCallbackMockFilter();
    private static ClientVenusMonitorFilter clientVenusMonitorFilter = null;
    private ClientAthenaMonitorFilter clientAthenaMonitorFilter = null;

    public ClientInvokerProxy() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws RpcException {
        ClientInvokerProxy clientInvokerProxy = this;
        synchronized (clientInvokerProxy) {
            VenusApplication venusApplication = VenusApplication.getInstance();
            if (venusApplication != null && venusApplication.isEnableFilter()) {
                this.initFilters();
            } else {
                logger.warn("venus application is undefined or disabled filters,will disable filters.");
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result invoke(Invocation invocation, URL url) throws RpcException {
        block15: {
            clientInvocation = (ClientInvocation)invocation;
            try {
                for (Filter filter : this.getBeforeFilters()) {
                    result = filter.beforeInvoke(invocation, null);
                    if (result == null) continue;
                    VenusThreadContext.set((String)"responseResult", (Object)result);
                    var7_8 = result;
                    var8_12 = this.getAfterFilters().iterator();
                    break block15;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable e) {
                try {
                    VenusThreadContext.set((String)"responseException", (Object)e);
                    var5_6 = this.getThrowFilters().iterator();
                    do {
                        if (var5_6.hasNext() == false) throw e;
                    } while ((result = (filter = var5_6.next()).throwInvoke(invocation, url, e)) == null);
                    VenusThreadContext.set((String)"responseResult", (Object)result);
                    var8_13 = result;
                    return var8_13;
                }
                catch (Throwable var11_17) {
                    throw var11_17;
                }
                finally {
                    var9_15 = this.getAfterFilters().iterator();
                    while (true) {
                        if (!var9_15.hasNext()) {
                        }
                        filter = var9_15.next();
                        filter.afterInvoke(invocation, url);
                    }
                }
            }
        }
        while (var8_12.hasNext() != false) {
            filter = var8_12.next();
            filter.afterInvoke(invocation, url);
        }
        return var7_8;
lbl-1000:
        // 1 sources

        {
            if (!this.isInjvmInvoke(clientInvocation)) ** GOTO lbl-1000
            result = this.getInjvmInvoker().invoke(invocation, url);
            VenusThreadContext.set((String)"responseResult", (Object)result);
            var5_6 = result;
            result = this.getAfterFilters().iterator();
        }
        while (result.hasNext() != false) {
            filter = (Filter)result.next();
            filter.afterInvoke(invocation, url);
        }
        return var5_6;
lbl-1000:
        // 1 sources

        {
            result = this.getRemoteInvoker().invoke(invocation, url);
            VenusThreadContext.set((String)"responseResult", (Object)result);
            var5_6 = result;
            result = this.getAfterFilters().iterator();
        }
        while (result.hasNext() != false) {
            filter = (Filter)result.next();
            filter.afterInvoke(invocation, url);
        }
        return var5_6;
    }

    boolean isInjvmInvoke(ClientInvocation invocation) {
        ServiceWrapper service = invocation.getService();
        EndpointWrapper endpoint = invocation.getEndpoint();
        if (endpoint != null && service != null) {
            return StringUtils.isNotEmpty((String)service.getImplement());
        }
        return true;
    }

    public ClientLocalInvoker getInjvmInvoker() {
        return this.injvmInvoker;
    }

    public ClientRemoteInvoker getRemoteInvoker() {
        if (this.remoteConfig != null) {
            this.clientRemoteInvoker.setRemoteConfig(this.remoteConfig);
        }
        if (this.register != null) {
            this.clientRemoteInvoker.setRegister(this.register);
        }
        return this.clientRemoteInvoker;
    }

    void initFilters() {
        this.initMonitorFilters();
        this.addBeforeFilters();
        this.addThrowFilters();
        this.addAfterFilters();
    }

    void initMonitorFilters() {
        VenusMonitorFactory venusMonitorFactory = VenusMonitorFactory.getInstance();
        if (venusMonitorFactory != null) {
            if (venusMonitorFactory.isEnableVenusReport()) {
                if (clientVenusMonitorFilter == null) {
                    try {
                        clientVenusMonitorFilter = new ClientVenusMonitorFilter();
                        clientVenusMonitorFilter.init();
                    }
                    catch (Exception e) {
                        logger.warn("#########init venus monitor failed,will disabled venus report.", (Throwable)e);
                    }
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn("############not enable venus report,venus monitor filter diabled##############");
            }
            if (venusMonitorFactory.isEnableAthenaReport()) {
                try {
                    this.clientAthenaMonitorFilter = new ClientAthenaMonitorFilter();
                    this.clientAthenaMonitorFilter.init();
                }
                catch (Throwable e) {
                    logger.warn("##########init athena monitor failed,will disabled athena report.", e);
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn("############not enable athena report,athena monitor filter diabled##############");
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("############not enable monitor report,vensu and athena monitor filter diabled##############");
        }
    }

    void addBeforeFilters() {
        this.beforeFilters.add(this.clientValidFilter);
        this.beforeFilters.add(this.clientActivesLimitFilter);
        this.beforeFilters.add(this.clientTpsLimitFilter);
        this.beforeFilters.add(this.clientReturnMockFilter);
        this.beforeFilters.add(this.clientThrowMockFilter);
        this.beforeFilters.add(this.clientCallbackMockFilter);
        if (clientVenusMonitorFilter != null) {
            this.beforeFilters.add((Filter)clientVenusMonitorFilter);
        }
        if (this.clientAthenaMonitorFilter != null) {
            this.beforeFilters.add((Filter)this.clientAthenaMonitorFilter);
        }
    }

    void addThrowFilters() {
        if (clientVenusMonitorFilter != null) {
            this.throwFilters.add((Filter)clientVenusMonitorFilter);
        }
        if (this.clientAthenaMonitorFilter != null) {
            this.throwFilters.add((Filter)this.clientAthenaMonitorFilter);
        }
    }

    void addAfterFilters() {
        this.afterFilters.add(this.clientActivesLimitFilter);
        if (clientVenusMonitorFilter != null) {
            this.afterFilters.add((Filter)clientVenusMonitorFilter);
        }
        if (this.clientAthenaMonitorFilter != null) {
            this.afterFilters.add((Filter)this.clientAthenaMonitorFilter);
        }
    }

    public List<Filter> getBeforeFilters() {
        return this.beforeFilters;
    }

    public List<Filter> getThrowFilters() {
        return this.throwFilters;
    }

    public List<Filter> getAfterFilters() {
        return this.afterFilters;
    }

    public void destroy() throws RpcException {
    }

    public ClientRemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public void setRemoteConfig(ClientRemoteConfig remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public Register getRegister() {
        return this.register;
    }

    public void setRegister(Register register) {
        this.register = register;
    }
}

