/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.filter.limit;

import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ClientTpsLimitFilter
implements Filter {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static Map<String, AtomicInteger> methodTpsMapping = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String LIMIT_TYPE_ACTIVE = "active_limit";
    private static final String LIMIT_TYPE_TPS = "tps_limit";
    private static final int DEFAULT_TPS_LIMIT = 5;
    private ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
    private static boolean isRunningTask = false;
    TimerTask resetAndReportTask = new TimerTask(){

        @Override
        public void run() {
            for (Map.Entry entry : methodTpsMapping.entrySet()) {
                String methodPath = (String)entry.getKey();
                AtomicInteger activeLimit = (AtomicInteger)entry.getValue();
                methodTpsMapping.put(methodPath, new AtomicInteger(0));
            }
        }
    };

    public ClientTpsLimitFilter() {
        if (!isRunningTask) {
            this.init();
            isRunningTask = true;
        }
    }

    public void init() throws RpcException {
        this.scheduledThreadPool.schedule(this.resetAndReportTask, 1000L, TimeUnit.MILLISECONDS);
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            boolean isExceedTpsLimit;
            ClientInvocation clientInvocation = (ClientInvocation)invocation;
            if (!this.isEnableTpsLimit(clientInvocation, url)) {
                return null;
            }
            String methodPath = VenusUtil.getMethodPath((Invocation)clientInvocation);
            AtomicInteger activeLimit = methodTpsMapping.get(methodPath);
            if (activeLimit == null) {
                activeLimit = new AtomicInteger(0);
                methodTpsMapping.put(methodPath, activeLimit);
            }
            if (isExceedTpsLimit = this.isExceedTpsLimit(methodPath, activeLimit)) {
                throw new RpcException("exceed tps limit.");
            }
            activeLimit.incrementAndGet();
            methodTpsMapping.put(methodPath, activeLimit);
            return null;
        }
        catch (RpcException e) {
            throw e;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ClientTpsLimitFilter.beforeInvoke error.", e);
            }
            return null;
        }
    }

    boolean isEnableTpsLimit(ClientInvocation invocation, URL url) {
        return false;
    }

    boolean isExceedTpsLimit(String methodPath, AtomicInteger tpsLimit) {
        int tps = tpsLimit.get();
        return tps > 5;
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        return null;
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        return null;
    }

    public void destroy() throws RpcException {
    }
}

