/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.filter.limit;

import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.filter.ServiceConfigUtil;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.registry.domain.FlowControl;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class ClientActivesLimitFilter
implements Filter {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static Map<String, AtomicInteger> methodActivesMapping = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String LIMIT_TYPE_ACTIVE = "active_limit";
    private static final String LIMIT_TYPE_TPS = "tps_limit";
    private static final int DEFAULT_ACTIVES_LIMIT = 5;

    public void init() throws RpcException {
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            boolean isExceedActiveLimit;
            ClientInvocation clientInvocation = (ClientInvocation)invocation;
            if (!this.isEnableActiveLimit(clientInvocation, url)) {
                return null;
            }
            String methodPath = VenusUtil.getMethodPath((Invocation)clientInvocation);
            AtomicInteger activeLimit = methodActivesMapping.get(methodPath);
            if (activeLimit == null) {
                activeLimit = new AtomicInteger(0);
                methodActivesMapping.put(methodPath, activeLimit);
            }
            if (isExceedActiveLimit = this.isExceedActiveLimit(clientInvocation, url, methodPath, activeLimit)) {
                throw new RpcException("exceed actives limit.");
            }
            activeLimit.incrementAndGet();
            methodActivesMapping.put(methodPath, activeLimit);
            return null;
        }
        catch (RpcException e) {
            throw e;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ClientActivesLimitFilter.beforeInvoke error.", e);
            }
            return null;
        }
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        return null;
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            ClientInvocation clientInvocation = (ClientInvocation)invocation;
            if (!this.isEnableActiveLimit(clientInvocation, url)) {
                return null;
            }
            String methodPath = VenusUtil.getMethodPath((Invocation)clientInvocation);
            AtomicInteger activeLimit = methodActivesMapping.get(methodPath);
            if (activeLimit != null) {
                activeLimit.decrementAndGet();
                methodActivesMapping.put(methodPath, activeLimit);
            }
            return null;
        }
        catch (RpcException e) {
            throw e;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ClientActivesLimitFilter.afterInvoke error.", e);
            }
            return null;
        }
    }

    boolean isEnableActiveLimit(ClientInvocation invocation, URL url) {
        FlowControl flowControl = this.filteMatchConfig(invocation, url);
        if (flowControl == null) {
            return false;
        }
        return LIMIT_TYPE_ACTIVE.equalsIgnoreCase(flowControl.getFcType());
    }

    boolean isExceedActiveLimit(ClientInvocation invocation, URL url, String methodPath, AtomicInteger activeLimit) {
        int actives = activeLimit.get();
        FlowControl flowControl = this.filteMatchConfig(invocation, url);
        if (flowControl == null) {
            return false;
        }
        return actives > flowControl.getThreshold();
    }

    FlowControl filteMatchConfig(ClientInvocation invocation, URL url) {
        List<FlowControl> configList = ServiceConfigUtil.getFlowConfigList(url);
        if (CollectionUtils.isEmpty(configList)) {
            return null;
        }
        for (FlowControl control : configList) {
            if (!control.isActive() || !"consumer".equalsIgnoreCase(control.getPosition()) || !invocation.getMethod().getName().equalsIgnoreCase(control.getMethod())) continue;
            return control;
        }
        return null;
    }

    public void destroy() throws RpcException {
    }
}

