/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.factory.xml;

import com.meidusa.fastjson.JSON;
import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.venus.ServiceFactory;
import com.meidusa.venus.ServiceFactoryBean;
import com.meidusa.venus.URL;
import com.meidusa.venus.VenusApplication;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.client.factory.AbstractServiceFactory;
import com.meidusa.venus.client.factory.InvokerInvocationHandler;
import com.meidusa.venus.client.factory.xml.config.ClientRemoteConfig;
import com.meidusa.venus.client.factory.xml.config.ReferenceMethod;
import com.meidusa.venus.client.factory.xml.config.ReferenceService;
import com.meidusa.venus.client.factory.xml.config.VenusClientConfig;
import com.meidusa.venus.client.factory.xml.support.ClientBeanContext;
import com.meidusa.venus.client.factory.xml.support.ClientBeanUtilsBean;
import com.meidusa.venus.client.factory.xml.support.ServiceDefinedBean;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.ServiceNotFoundException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.metainfo.AnnotationUtil;
import com.meidusa.venus.monitor.VenusMonitorFactory;
import com.meidusa.venus.registry.Register;
import com.meidusa.venus.registry.VenusRegistryFactory;
import com.meidusa.venus.support.VenusContext;
import com.meidusa.venus.util.NetUtil;
import com.meidusa.venus.util.VenusBeanUtilsBean;
import com.meidusa.venus.util.VenusLoggerFactory;
import com.thoughtworks.xstream.XStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class XmlServiceFactory
extends AbstractServiceFactory
implements ServiceFactory,
InitializingBean,
BeanFactoryPostProcessor,
ApplicationContextAware {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private Resource[] configFiles;
    private Map<Class<?>, ServiceDefinedBean> serviceMap = new HashMap();
    private boolean shutdown = false;
    private boolean inited = false;
    private ApplicationContext applicationContext;
    private BeanContext beanContext;
    private VenusApplication venusApplication;
    private VenusRegistryFactory venusRegistryFactory;
    private VenusMonitorFactory venusMonitorFactory;

    public XmlServiceFactory() {
        VenusApplication.addServiceFactory((ServiceFactory)this);
    }

    public <T> T getService(Class<T> t) {
        if (this.shutdown) {
            throw new IllegalStateException("service factory has been shutdown");
        }
        ServiceDefinedBean object = this.serviceMap.get(t);
        if (object == null) {
            throw new ServiceNotFoundException(t.getName() + " not defined");
        }
        return (T)object.getService();
    }

    public <T> T getService(String name, Class<T> t) {
        if (this.shutdown) {
            throw new IllegalStateException("service factory has been shutdown");
        }
        ServiceDefinedBean object = this.serviceMap.get(t);
        if (object == null) {
            throw new ServiceNotFoundException(t.getName() + " not defined");
        }
        return (T)object.getService();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.valid();
        this.initContext();
        this.initConfiguration();
    }

    void valid() {
        if (this.venusApplication == null) {
            throw new VenusConfigException("venusApplication not config.");
        }
        if ((this.venusRegistryFactory == null || this.venusRegistryFactory.getRegister() == null) && logger.isWarnEnabled()) {
            logger.warn("venusRegistryFactory not enabled,will disable service subscrible.");
        }
        if (this.venusMonitorFactory == null && logger.isWarnEnabled()) {
            logger.warn("venusMonitorFactory not enabled,will disable monitor reporte.");
        }
    }

    void initContext() {
        if (logger.isDebugEnabled()) {
            logger.debug("current Venus Client id=" + PacketConstant.VENUS_CLIENT_ID);
        }
        if (this.applicationContext != null) {
            VenusContext.getInstance().setApplicationContext(this.applicationContext);
        }
        this.beanContext = new ClientBeanContext((BeanFactory)(this.applicationContext != null ? this.applicationContext.getAutowireCapableBeanFactory() : null));
        BeanContextBean.getInstance().setBeanContext(this.beanContext);
        if (this.beanContext != null) {
            VenusContext.getInstance().setBeanContext(this.beanContext);
        }
        VenusBeanUtilsBean.setInstance((BeanUtilsBean)new ClientBeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean(), this.beanContext));
    }

    private void initConfiguration() throws Exception {
        VenusClientConfig venusClientConfig = this.parseClientConfig();
        if (CollectionUtils.isEmpty(venusClientConfig.getReferenceServices())) {
            return;
        }
        for (ReferenceService referenceService : venusClientConfig.getReferenceServices()) {
            this.initService(referenceService);
        }
        if (this.venusRegistryFactory != null && this.venusRegistryFactory.getRegister() != null) {
            this.venusRegistryFactory.getRegister().load();
        }
    }

    void initService(ReferenceService referenceService) {
        block3: {
            this.initServiceProxy(referenceService);
            if (this.isNeedSubscrible(referenceService)) {
                try {
                    this.subscribleService(referenceService);
                }
                catch (Exception e) {
                    if (!exceptionLogger.isErrorEnabled()) break block3;
                    exceptionLogger.error("subscrible service failed,will retry.", (Throwable)e);
                }
            }
        }
    }

    boolean isNeedSubscrible(ReferenceService referenceService) {
        if (StringUtils.isNotEmpty((String)referenceService.getRemote()) || StringUtils.isNotEmpty((String)referenceService.getIpAddressList())) {
            if (logger.isWarnEnabled()) {
                logger.warn("direct connect provider,will skip subscrible service.");
            }
            return false;
        }
        if ((this.venusRegistryFactory == null || this.venusRegistryFactory.getRegister() == null) && logger.isWarnEnabled()) {
            logger.warn("venusRegistryFactory not config,will skip subscrible service.");
        }
        return true;
    }

    void initServiceProxy(ReferenceService referenceService) {
        if (logger.isInfoEnabled()) {
            logger.info("init service proxy:{}.", (Object)referenceService.getServiceInterface().getName());
        }
        if (StringUtils.isEmpty((String)referenceService.getIpAddressList()) && (this.venusRegistryFactory == null || this.venusRegistryFactory.getRegister() == null)) {
            throw new VenusConfigException("init serivce proxy failed,ipAddressList and venusRegistryFactory not config.");
        }
        InvokerInvocationHandler invocationHandler = new InvokerInvocationHandler();
        invocationHandler.setServiceInterface(referenceService.getServiceInterface());
        if (StringUtils.isNotEmpty((String)referenceService.getIpAddressList())) {
            ClientRemoteConfig remoteConfig = this.newRemoteConfig(referenceService);
            invocationHandler.setRemoteConfig(remoteConfig);
        } else {
            invocationHandler.setRegister(this.venusRegistryFactory.getRegister());
        }
        invocationHandler.setReferenceService(referenceService);
        invocationHandler.setServiceFactory(this);
        Object serviceProxyObject = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{referenceService.getServiceInterface()}, (InvocationHandler)invocationHandler);
        ServiceDefinedBean serviceDefinedBean = new ServiceDefinedBean();
        serviceDefinedBean.setName(referenceService.getName());
        serviceDefinedBean.setServiceName(referenceService.getServiceName());
        serviceDefinedBean.setServiceInterface(referenceService.getServiceInterface());
        serviceDefinedBean.setService(serviceProxyObject);
        serviceDefinedBean.setHandler(invocationHandler);
        this.serviceMap.put(referenceService.getServiceInterface(), serviceDefinedBean);
    }

    void subscribleService(ReferenceService referenceService) {
        if (StringUtils.isNotEmpty((String)referenceService.getRemote()) || StringUtils.isNotEmpty((String)referenceService.getIpAddressList())) {
            return;
        }
        String appName = this.venusApplication.getName();
        String serviceInterfaceName = "null";
        if (referenceService.getType() != null) {
            serviceInterfaceName = referenceService.getServiceInterface().getName();
        }
        String serivceName = referenceService.getServiceName();
        String consumerHost = NetUtil.getLocalIp();
        StringBuffer buf = new StringBuffer();
        buf.append("/").append(serviceInterfaceName);
        buf.append("/").append(serivceName);
        buf.append("?application=").append(appName);
        buf.append("&host=").append(consumerHost);
        String subscribleUrl = buf.toString();
        URL url = URL.parse((String)subscribleUrl);
        this.venusRegistryFactory.getRegister().subscrible(url);
    }

    ClientRemoteConfig newRemoteConfig(ReferenceService referenceService) {
        if (StringUtils.isNotEmpty((String)referenceService.getIpAddressList())) {
            ClientRemoteConfig remoteConfig = ClientRemoteConfig.newInstace(referenceService.getIpAddressList());
            return remoteConfig;
        }
        return null;
    }

    VenusClientConfig parseClientConfig() {
        VenusClientConfig allVenusClientConfig = new VenusClientConfig();
        XStream xStream = new XStream();
        xStream.autodetectAnnotations(true);
        xStream.processAnnotations(VenusClientConfig.class);
        xStream.processAnnotations(ReferenceService.class);
        for (Resource configFile : this.configFiles) {
            try {
                VenusClientConfig venusClientConfig = (VenusClientConfig)xStream.fromXML(configFile.getURL());
                if (CollectionUtils.isEmpty(venusClientConfig.getReferenceServices())) continue;
                for (ReferenceService referenceService : venusClientConfig.getReferenceServices()) {
                    String serviceInterfaceName = referenceService.getType();
                    if (serviceInterfaceName == null) {
                        throw new VenusConfigException("service type can not be null:" + configFile.getFilename());
                    }
                    Class<?> serviceInterface = null;
                    try {
                        serviceInterface = Class.forName(serviceInterfaceName);
                        referenceService.setServiceInterface(serviceInterface);
                    }
                    catch (ClassNotFoundException e) {
                        throw new VenusConfigException("service interface class not found:" + serviceInterfaceName);
                    }
                    Service serviceAnno = (Service)AnnotationUtil.getAnnotation((Annotation[])serviceInterface.getAnnotations(), Service.class);
                    if (serviceAnno == null) {
                        throw new VenusConfigException(String.format("service %s service annotation not declare", serviceInterface.getName()));
                    }
                    String serviceName = serviceAnno.name();
                    if (StringUtils.isEmpty((String)serviceName)) {
                        serviceName = serviceInterface.getCanonicalName();
                    }
                    referenceService.setServiceName(serviceName);
                    referenceService.setVersion(serviceAnno.version());
                    if (StringUtils.isNotEmpty((String)referenceService.getIpAddressList())) {
                        String ipAddressList = this.parseAddress(referenceService.getIpAddressList());
                        referenceService.setIpAddressList(ipAddressList);
                    }
                    if (StringUtils.isNotEmpty((String)referenceService.getTimeout())) {
                        String timeout = this.parseProperty(referenceService.getTimeout());
                        referenceService.setTimeoutCfg(Integer.parseInt(timeout));
                    }
                    if (StringUtils.isNotEmpty((String)referenceService.getRetries())) {
                        String retries = this.parseProperty(referenceService.getRetries());
                        referenceService.setRetriesCfg(Integer.parseInt(retries));
                    }
                    if (CollectionUtils.isNotEmpty(referenceService.getMethodList())) {
                        for (ReferenceMethod referenceMethod : referenceService.getMethodList()) {
                            if (StringUtils.isNotEmpty((String)referenceMethod.getTimeout())) {
                                String timeout = this.parseProperty(referenceMethod.getTimeout());
                                referenceMethod.setTimeoutCfg(Integer.parseInt(timeout));
                            }
                            if (!StringUtils.isNotEmpty((String)referenceMethod.getRetries())) continue;
                            String retries = this.parseProperty(referenceMethod.getRetries());
                            referenceMethod.setRetriesCfg(Integer.parseInt(retries));
                        }
                    }
                    XmlVenusExceptionFactory venusExceptionFactory = XmlVenusExceptionFactory.getInstance();
                    for (Method method : serviceInterface.getMethods()) {
                        Class<?>[] eclazz;
                        Endpoint endpoint = method.getAnnotation(Endpoint.class);
                        if (endpoint == null) continue;
                        for (Class<?> clazz : eclazz = method.getExceptionTypes()) {
                            if (venusExceptionFactory == null || !CodedException.class.isAssignableFrom(clazz)) continue;
                            venusExceptionFactory.addException(clazz);
                        }
                    }
                    allVenusClientConfig.getReferenceServices().add(referenceService);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("parse venus client config failed:" + configFile.getFilename(), (Throwable)e);
            }
        }
        return allVenusClientConfig;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashMap<String, String> refBeanMap = new HashMap<String, String>();
        for (Map.Entry<Class<?>, ServiceDefinedBean> entry : this.serviceMap.entrySet()) {
            ServiceDefinedBean srvDefBean = entry.getValue();
            if (!(beanFactory instanceof BeanDefinitionRegistry)) continue;
            BeanDefinitionRegistry reg = (BeanDefinitionRegistry)beanFactory;
            String beanName = srvDefBean.getName();
            if (StringUtils.isEmpty((String)beanName)) {
                beanName = srvDefBean.getServiceName().concat("#0");
            }
            if (StringUtils.isEmpty((String)beanName)) {
                throw new VenusConfigException("spring bean name and annotation service name is empty:" + srvDefBean.getServiceInterface());
            }
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(ServiceFactoryBean.class);
            beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)beanName));
            beanDefinition.setScope("singleton");
            ConstructorArgumentValues args = new ConstructorArgumentValues();
            args.addIndexedArgumentValue(0, srvDefBean.getService());
            args.addIndexedArgumentValue(1, srvDefBean.getServiceInterface());
            beanDefinition.setConstructorArgumentValues(args);
            beanDefinition.setAutowireMode(1);
            reg.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            refBeanMap.put(beanName, srvDefBean.getServiceInterface().getName());
        }
        if (this.isPrintRefBean() && logger.isInfoEnabled()) {
            logger.info("##########ref beans##############:\n{}.", (Object)JSON.toJSONString(refBeanMap, (boolean)true));
        }
    }

    public void destroy() {
        Register register;
        if (this.shutdown) {
            return;
        }
        if (this.venusRegistryFactory != null && this.venusRegistryFactory.getRegister() != null && (register = this.venusRegistryFactory.getRegister()) != null) {
            register.destroy();
        }
        this.shutdown = true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Resource[] getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(Resource ... configFiles) {
        this.configFiles = configFiles;
    }

    public VenusRegistryFactory getVenusRegistryFactory() {
        return this.venusRegistryFactory;
    }

    public void setVenusRegistryFactory(VenusRegistryFactory venusRegistryFactory) {
        this.venusRegistryFactory = venusRegistryFactory;
    }

    public VenusApplication getVenusApplication() {
        return this.venusApplication;
    }

    public void setVenusApplication(VenusApplication venusApplication) {
        this.venusApplication = venusApplication;
    }

    public VenusMonitorFactory getVenusMonitorFactory() {
        return this.venusMonitorFactory;
    }

    public void setVenusMonitorFactory(VenusMonitorFactory venusMonitorFactory) {
        this.venusMonitorFactory = venusMonitorFactory;
    }

    public boolean isPrintRefBean() {
        return true;
    }
}

