/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.factory.simple;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.ServiceFactoryExtra;
import com.meidusa.venus.URL;
import com.meidusa.venus.VenusApplication;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.client.factory.AbstractServiceFactory;
import com.meidusa.venus.client.factory.InvokerInvocationHandler;
import com.meidusa.venus.client.factory.xml.config.ClientRemoteConfig;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.io.authenticate.Authenticator;
import com.meidusa.venus.io.authenticate.DummyAuthenticator;
import com.meidusa.venus.metainfo.AnnotationUtil;
import com.meidusa.venus.registry.Register;
import com.meidusa.venus.util.NetUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class SimpleServiceFactory
extends AbstractServiceFactory
implements ServiceFactoryExtra {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private String ipAddressList;
    private Register register;
    private String appName = "unknow app";
    private int soTimeout = 15000;
    private int coTimeout = 5000;
    private Authenticator authenticator;
    private Map<Class<?>, Tuple<Object, InvokerInvocationHandler>> servicesMap = new HashMap();

    public SimpleServiceFactory() {
    }

    public SimpleServiceFactory(String host, int port) {
        String address;
        this.ipAddressList = address = String.format("%s:%s", host, String.valueOf(port));
    }

    public void setAddressList(String ipAddressList) {
        if (StringUtils.isEmpty((String)ipAddressList)) {
            throw new VenusConfigException("ipAddressList is empty.");
        }
        this.ipAddressList = ipAddressList = this.parseAddress(ipAddressList);
    }

    public void setRegister(Object register) {
        Register reg;
        this.register = reg = (Register)register;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getCoTimeout() {
        return this.coTimeout;
    }

    public void setCoTimeout(int coTimeout) {
        this.coTimeout = coTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> t) {
        Tuple<Object, InvokerInvocationHandler> object = this.servicesMap.get(t);
        if (object == null) {
            Map<Class<?>, Tuple<Object, InvokerInvocationHandler>> map = this.servicesMap;
            synchronized (map) {
                object = this.servicesMap.get(t);
                if (object == null) {
                    T obj = this.initService(t);
                    return obj;
                }
            }
        }
        return (T)object.left;
    }

    protected <T> T initService(Class<T> t) {
        T serviceProxy;
        block3: {
            serviceProxy = this.initServiceProxy(t);
            if (StringUtils.isEmpty((String)this.ipAddressList) && this.register != null) {
                try {
                    this.subscribleService(t);
                    this.register.load();
                }
                catch (Exception e) {
                    if (!exceptionLogger.isErrorEnabled()) break block3;
                    exceptionLogger.error("subscrible service failed,will retry.", (Throwable)e);
                }
            }
        }
        return serviceProxy;
    }

    <T> T initServiceProxy(Class<T> t) {
        if (logger.isInfoEnabled()) {
            logger.info("init service proxy:{}.", (Object)t.getName());
        }
        InvokerInvocationHandler invocationHandler = new InvokerInvocationHandler();
        invocationHandler.setServiceInterface(t);
        if (StringUtils.isNotEmpty((String)this.ipAddressList)) {
            invocationHandler.setRemoteConfig(ClientRemoteConfig.newInstace(this.ipAddressList));
        } else if (this.register != null) {
            invocationHandler.setRegister(this.register);
        } else {
            throw new VenusConfigException("ipAddressList and register not allow empty.");
        }
        if (this.getAuthenticator() == null) {
            this.authenticator = new DummyAuthenticator();
        }
        Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{t}, (InvocationHandler)invocationHandler);
        XmlVenusExceptionFactory venusExceptionFactory = XmlVenusExceptionFactory.getInstance();
        for (Method method : t.getMethods()) {
            Class<?>[] eclazz;
            Endpoint endpoint = method.getAnnotation(Endpoint.class);
            if (endpoint == null) continue;
            for (Class<?> clazz : eclazz = method.getExceptionTypes()) {
                if (venusExceptionFactory == null || !CodedException.class.isAssignableFrom(clazz)) continue;
                venusExceptionFactory.addException(clazz);
            }
        }
        Tuple serviceTuple = new Tuple(object, (Object)invocationHandler);
        this.servicesMap.put(t, (Tuple<Object, InvokerInvocationHandler>)serviceTuple);
        return (T)object;
    }

    <T> void subscribleService(Class<T> t) {
        String appName = this.appName;
        VenusApplication venusApplication = VenusApplication.getInstance();
        if (venusApplication != null && StringUtils.isNotEmpty((String)venusApplication.getName())) {
            appName = venusApplication.getName();
        }
        String serviceInterfaceName = t.getName();
        Service service = (Service)AnnotationUtil.getAnnotation((Annotation[])t.getAnnotations(), Service.class);
        String serivceName = null;
        serivceName = service != null ? service.name() : t.getCanonicalName();
        String consumerHost = NetUtil.getLocalIp();
        StringBuffer buf = new StringBuffer();
        buf.append("/").append(serviceInterfaceName);
        buf.append("/").append(serivceName);
        buf.append("?application=").append(appName);
        buf.append("&host=").append(consumerHost);
        String subscribleUrl = buf.toString();
        URL url = URL.parse((String)subscribleUrl);
        this.register.subscrible(url);
    }

    public void destroy() {
    }

    public <T> T getService(String name, Class<T> t) {
        return this.getService(t);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

