/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.factory;

import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.ServiceFactory;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.factory.xml.config.ClientRemoteConfig;
import com.meidusa.venus.client.factory.xml.config.ReferenceMethod;
import com.meidusa.venus.client.factory.xml.config.ReferenceService;
import com.meidusa.venus.client.invoker.ClientInvokerProxy;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.utils.RpcIdUtil;
import com.meidusa.venus.metainfo.AnnotationUtil;
import com.meidusa.venus.metainfo.EndpointParameter;
import com.meidusa.venus.metainfo.EndpointParameterUtil;
import com.meidusa.venus.registry.Register;
import com.meidusa.venus.support.EndpointWrapper;
import com.meidusa.venus.support.ServiceWrapper;
import com.meidusa.venus.support.VenusContext;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.JSONUtil;
import com.meidusa.venus.util.NetUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import com.meidusa.venus.util.VenusTracerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class InvokerInvocationHandler
implements InvocationHandler {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static Logger tracerLogger = VenusLoggerFactory.getTracerLogger();
    private Class<?> serviceInterface;
    private ServiceFactory serviceFactory;
    private ReferenceService referenceService;
    private ClientRemoteConfig remoteConfig;
    private Register register;
    private ClientInvokerProxy clientInvokerProxy = new ClientInvokerProxy();
    private static AtomicLong sequenceId = new AtomicLong(1L);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Result result;
        Throwable exception;
        Object object;
        ClientInvocation invocation;
        long bTime;
        block10: {
            if (this.isObjectInvoke(proxy, method, args)) {
                return this.invokeObject(proxy, method, args);
            }
            bTime = System.currentTimeMillis();
            invocation = null;
            object = null;
            exception = null;
            invocation = this.buildInvocation(proxy, method, args);
            result = this.getClientInvokerProxy().invoke((Invocation)invocation, null);
            if (result.getErrorCode() != 0 || result.getException() != null) break block10;
            Object object2 = object = result.getResult();
            try {
                this.printTracerLogger(invocation, object, exception, bTime);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return object2;
        }
        try {
            try {
                exception = this.buildException(result);
                throw exception;
            }
            catch (Throwable t) {
                exception = t;
                throw exception;
            }
        }
        catch (Throwable throwable) {
            try {
                this.printTracerLogger(invocation, object, exception, bTime);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public ClientInvokerProxy getClientInvokerProxy() {
        this.clientInvokerProxy.setRemoteConfig(this.getRemoteConfig());
        this.clientInvokerProxy.setRegister(this.register);
        return this.clientInvokerProxy;
    }

    ClientInvocation buildInvocation(Object proxy, Method method, Object[] args) {
        ClientInvocation invocation = new ClientInvocation();
        invocation.setServiceInterface(this.serviceInterface);
        Service serviceAnno = (Service)AnnotationUtil.getAnnotation((Annotation[])method.getDeclaringClass().getAnnotations(), Service.class);
        if (serviceAnno == null) {
            throw new VenusConfigException(String.format("service %s service annotation not declare", this.serviceInterface.getName()));
        }
        ServiceWrapper serviceWrapper = ServiceWrapper.wrapper((Service)serviceAnno);
        invocation.setService(serviceWrapper);
        String serviceName = serviceAnno.name();
        if (StringUtils.isEmpty((String)serviceName)) {
            serviceName = this.serviceInterface.getCanonicalName();
        }
        invocation.setServiceName(serviceName);
        invocation.setVersion(String.valueOf(serviceAnno.version()));
        Endpoint endpointAnno = (Endpoint)AnnotationUtil.getAnnotation((Annotation[])method.getAnnotations(), Endpoint.class);
        if (endpointAnno == null) {
            throw new VenusConfigException(String.format("method %s endpoint annotation not declare", method.getName()));
        }
        EndpointWrapper endpointWrapper = EndpointWrapper.wrapper((Endpoint)endpointAnno);
        invocation.setEndpoint(endpointWrapper);
        String apiName = VenusUtil.getApiName((Method)method, (ServiceWrapper)serviceWrapper, (EndpointWrapper)endpointWrapper);
        invocation.setApiName(apiName);
        EndpointParameter[] params = EndpointParameterUtil.getPrameters((Method)method);
        invocation.setParams(params);
        invocation.setMethod(method);
        invocation.setArgs(args);
        invocation.setRequestTime(new Date());
        String consumerApp = VenusContext.getInstance().getApplication();
        invocation.setConsumerApp(consumerApp);
        invocation.setConsumerIp(NetUtil.getLocalIp((boolean)true));
        invocation.setAsync(false);
        invocation.setClientId(PacketConstant.VENUS_CLIENT_ID);
        invocation.setClientRequestId(sequenceId.getAndIncrement());
        invocation.setRpcId(RpcIdUtil.getRpcId((int)invocation.getClientId(), (long)invocation.getClientRequestId()));
        byte[] traceID = VenusTracerUtil.getTracerID();
        if (traceID == null) {
            traceID = VenusTracerUtil.randomTracerID();
        }
        invocation.setTraceID(traceID);
        if (this.register != null) {
            invocation.setLookupType(1);
        }
        if (this.referenceService != null) {
            ReferenceMethod referenceMethod = this.getReferenceMethod(method);
            if (this.referenceService.getCoreConnections() != 0) {
                invocation.setCoreConnections(this.referenceService.getCoreConnections());
            }
            if (referenceMethod != null && referenceMethod.getTimeoutCfg() != 0) {
                invocation.setTimeout(referenceMethod.getTimeoutCfg());
            } else if (this.referenceService.getTimeoutCfg() != 0) {
                invocation.setTimeout(this.referenceService.getTimeoutCfg());
            }
            if (referenceMethod != null && referenceMethod.getRetriesCfg() != 0) {
                invocation.setRetries(referenceMethod.getRetriesCfg());
            } else if (this.referenceService.getRetriesCfg() != 0) {
                invocation.setRetries(this.referenceService.getRetriesCfg());
            }
            if (StringUtils.isNotEmpty((String)this.referenceService.getCluster())) {
                invocation.setCluster(this.referenceService.getCluster());
            }
            if (StringUtils.isNotEmpty((String)this.referenceService.getLoadbalance())) {
                invocation.setLoadbalance(this.referenceService.getLoadbalance());
            }
        }
        return invocation;
    }

    ReferenceMethod getReferenceMethod(Method method) {
        List<ReferenceMethod> methodList = this.referenceService.getMethodList();
        if (CollectionUtils.isEmpty(methodList)) {
            return null;
        }
        for (ReferenceMethod rMethod : methodList) {
            if (rMethod.getName() == null || !method.getName().equals(rMethod.getName())) continue;
            return rMethod;
        }
        return null;
    }

    Throwable buildException(Result result) {
        Throwable rex = null;
        Throwable exception = result.getException();
        if (exception == null) {
            rex = new RpcException(String.format("%s-%s", String.valueOf(result.getErrorCode()), result.getErrorMessage()));
        }
        rex = exception instanceof RpcException ? (exception.getCause() != null ? exception.getCause() : exception) : exception;
        return rex;
    }

    void printTracerLogger(ClientInvocation invocation, Object object, Throwable exception, long bTime) {
        boolean hasException = false;
        long usedTime = System.currentTimeMillis() - bTime;
        String rpcId = invocation.getRpcId();
        String methodPath = invocation.getMethodPath();
        String param = "{}";
        if (invocation.isEnablePrintParam() && !VenusUtil.isAthenaInterface((Invocation)invocation) && invocation.getArgs() != null) {
            param = JSONUtil.toJSONString((Object)invocation.getArgs());
        }
        String ret = "{}";
        if (invocation.isEnablePrintResult() && !VenusUtil.isAthenaInterface((Invocation)invocation) && object != null) {
            ret = JSONUtil.toJSONString((Object)object);
        }
        Object error = "{}";
        if (invocation.isEnablePrintResult() && !VenusUtil.isAthenaInterface((Invocation)invocation) && exception != null) {
            hasException = true;
            error = exception;
        }
        String status = "";
        status = hasException ? "failed" : (usedTime > 1000L ? ">1000ms" : (usedTime > 500L ? ">500ms" : (usedTime > 200L ? ">200ms" : "<200ms")));
        Logger trLogger = tracerLogger;
        if (VenusUtil.isAthenaInterface((Invocation)invocation)) {
            trLogger = logger;
        }
        if (hasException) {
            String tpl = "[C] [{},{}],consumer invoke,rpcId:{},method:{},param:{},error:{}.";
            Object[] arguments = new Object[]{status, usedTime + "ms", rpcId, methodPath, param, error};
            if (trLogger.isErrorEnabled()) {
                trLogger.error(tpl, arguments);
            }
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error(tpl, arguments);
            }
        } else {
            String tpl = "[C] [{},{}],consumer invoke,rpcId:{},method:{},param:{},result:{}.";
            Object[] arguments = new Object[]{status, usedTime + "ms", rpcId, methodPath, param, ret};
            if (usedTime > 200L) {
                if (trLogger.isWarnEnabled()) {
                    trLogger.warn(tpl, arguments);
                }
            } else if (trLogger.isInfoEnabled()) {
                trLogger.info(tpl, arguments);
            }
        }
    }

    boolean isObjectInvoke(Object proxy, Method method, Object[] args) {
        Class<?> declaringClazz = method.getDeclaringClass();
        if (declaringClazz == null) {
            throw new IllegalStateException(String.valueOf(method));
        }
        return Object.class == declaringClazz;
    }

    Object invokeObject(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if ("equals".equals(name)) {
            return proxy == args[0];
        }
        if ("hashCode".equals(name)) {
            return System.identityHashCode(proxy);
        }
        if ("toString".equals(name)) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy)) + "," + this;
        }
        throw new IllegalStateException(String.valueOf(method));
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public ClientRemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public void setRemoteConfig(ClientRemoteConfig remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public Register getRegister() {
        return this.register;
    }

    public void setRegister(Register register) {
        this.register = register;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public ReferenceService getReferenceService() {
        return this.referenceService;
    }

    public void setReferenceService(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }
}

