/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.factory;

import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.util.VenusLoggerFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class AbstractServiceFactory {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();

    protected String parseAddress(String ipAddressList) {
        if (StringUtils.isEmpty((String)(ipAddressList = this.parseProperty(ipAddressList)))) {
            throw new VenusConfigException("ipAddressList is null.");
        }
        if ((ipAddressList = ipAddressList.trim()).contains(",")) {
            ipAddressList = ipAddressList.replace(",", ";");
        }
        this.validAddress(ipAddressList);
        return ipAddressList;
    }

    void validAddress(String ipAddressList) {
        String[] addressArr = ipAddressList.split(";");
        if (addressArr == null || addressArr.length == 0) {
            throw new VenusConfigException("ipAddressList invalid:" + ipAddressList);
        }
        for (String address : addressArr) {
            String[] arr = address.split(":");
            if (arr != null && arr.length == 2) continue;
            throw new VenusConfigException("ipAddressList invalid:" + ipAddressList);
        }
    }

    protected String parseProperty(String propertyValue) {
        if (StringUtils.isNotEmpty((String)propertyValue) && propertyValue.startsWith("${") && propertyValue.endsWith("}")) {
            String ucmPropertyValue = (String)ConfigUtil.filter((String)propertyValue);
            if (logger.isInfoEnabled()) {
                logger.info("##########parse ucm config item,placeholder:{},value:{}#############.", (Object)propertyValue, (Object)ucmPropertyValue);
            }
            return ucmPropertyValue;
        }
        return propertyValue;
    }
}

