/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.cluster;

import com.meidusa.venus.ClusterInvoker;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.cluster.AbstractClusterInvoker;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.List;
import org.slf4j.Logger;

public class ClusterFailoverInvoker
extends AbstractClusterInvoker
implements ClusterInvoker {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();

    public ClusterFailoverInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void init() throws RpcException {
    }

    public Result invoke(Invocation invocation, List<URL> urlList) throws RpcException {
        ClientInvocation clientInvocation = (ClientInvocation)invocation;
        int retries = clientInvocation.getRetries();
        if (retries < 1) {
            retries = 1;
        }
        for (int i = 0; i < retries; ++i) {
            try {
                return this.doInvokeForNetworkFailover(invocation, urlList);
            }
            catch (RpcException e) {
                if (e.isTimeout()) {
                    if (i < retries) continue;
                    throw e;
                }
                throw e;
            }
            catch (Throwable t) {
                throw t;
            }
        }
        throw new RpcException(String.format("invoke serivce %s,method %s failed with %d tries.", invocation.getServiceName(), invocation.getMethodName(), retries));
    }

    public void destroy() throws RpcException {
    }
}

