/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.cluster;

import com.meidusa.venus.ClusterInvoker;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.client.ClientInvocation;
import com.meidusa.venus.client.cluster.loadbalance.Loadbalance;
import com.meidusa.venus.client.cluster.loadbalance.RandomLoadbalance;
import com.meidusa.venus.client.cluster.loadbalance.RoundLoadbalance;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public abstract class AbstractClusterInvoker
implements ClusterInvoker {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private RandomLoadbalance randomLoadbanlance = new RandomLoadbalance();
    private RoundLoadbalance roundLoadbanlance = new RoundLoadbalance();
    private static Map<String, RandomLoadbalance> randomLbMap = new ConcurrentHashMap<String, RandomLoadbalance>();
    private static Map<String, RoundLoadbalance> roundLbMap = new ConcurrentHashMap<String, RoundLoadbalance>();
    protected Invoker invoker = null;

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    Result doInvokeForNetworkFailover(Invocation invocation, List<URL> urlList) throws RpcException {
        ClientInvocation clientInvocation = (ClientInvocation)invocation;
        int networkFailRetries = 3;
        for (int i = 0; i < networkFailRetries; ++i) {
            try {
                URL url = this.getLoadbanlance(clientInvocation.getLoadbalance(), clientInvocation).select(urlList);
                if (logger.isDebugEnabled()) {
                    logger.debug("select service provider:\u3010{}\u3011.", (Object)new StringBuilder().append(url.getHost()).append(":").append(url.getPort()));
                }
                return this.getInvoker().invoke(invocation, url);
            }
            catch (RpcException e) {
                if (e.isNetwork()) {
                    if (i < networkFailRetries) continue;
                    throw e;
                }
                throw e;
            }
            catch (Throwable t) {
                throw t;
            }
        }
        throw new RpcException(String.format("invoke method:%s/%s failed,cannot get connection.", invocation.getServiceName(), invocation.getMethodName()));
    }

    Loadbalance getLoadbanlance(String lb, ClientInvocation clientInvocation) {
        String servicePath = clientInvocation.getServicePath();
        if ("random".equals(lb)) {
            if (randomLbMap.get(servicePath) == null) {
                randomLbMap.put(servicePath, this.randomLoadbanlance);
            }
            return randomLbMap.get(servicePath);
        }
        if ("round".equals(lb)) {
            if (roundLbMap.get(servicePath) == null) {
                roundLbMap.put(servicePath, this.roundLoadbanlance);
            }
            return roundLbMap.get(servicePath);
        }
        throw new RpcException("unspport loadbanlance policy.");
    }
}

