/*
 * Copyright 2008-2108 amoeba.meidusa.com 
 * 
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.meidusa.venus.client.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;


import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;

import com.meidusa.venus.client.authenticate.Authenticator;
import com.meidusa.venus.client.authenticate.DummyAuthenticator;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.toolkit.net.BIOConnection;
import com.meidusa.toolkit.net.util.AuthenticationException;

/**
 * 
 * @author Struct
 *
 */
public class VenusBIOConnectionFactory implements PoolableObjectFactory {
	private static Logger authenticatorLogger = Logger.getLogger(Authenticator.class);
	protected static PingPacket PING_PACKET = new PingPacket();
	private int sendBufferSize = 64;
	private int receiveBufferSize = 64;
	private boolean tcpNoDelay = true;
	private boolean keepAlive = true;
	private int coTimeout = -1;
	private String ipAddress;
	private int port = 16800;
	private int soTimeout = -1;
	private boolean needPing = false;
	private Authenticator<HandshakePacket,AuthenPacket> authenticator = new DummyAuthenticator();
	public int getCoTimeout() {
		return coTimeout;
	}

	public void setCoTimeout(int coTimeout) {
		this.coTimeout = coTimeout;
	}

	public boolean isNeedPing() {
		return needPing;
	}

	public void setNeedPing(boolean needPing) {
		this.needPing = needPing;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	
	public int getSoTimeout() {
		return soTimeout;
	}

	public void setSoTimeout(int soTimeout) {
		this.soTimeout = soTimeout;
	}

	public int getSendBufferSize() {
		return sendBufferSize;
	}

	public void setSendBufferSize(int sendBufferSize) {
		this.sendBufferSize = sendBufferSize;
	}

	public int getReceiveBufferSize() {
		return receiveBufferSize;
	}

	public void setReceiveBufferSize(int receiveBufferSize) {
		this.receiveBufferSize = receiveBufferSize;
	}

	public boolean isTcpNoDelay() {
		return tcpNoDelay;
	}

	public void setTcpNoDelay(boolean tcpNoDelay) {
		this.tcpNoDelay = tcpNoDelay;
	}

	public boolean isKeepAlive() {
		return keepAlive;
	}

	public void setKeepAlive(boolean keepAlive) {
		this.keepAlive = keepAlive;
	}

	public void activateObject(Object arg0) throws Exception {

	}

	public Authenticator<HandshakePacket,AuthenPacket> getAuthenticator() {
		return authenticator;
	}

	public void setAuthenticator(Authenticator<HandshakePacket,AuthenPacket> authenticator) {
		this.authenticator = authenticator;
	}
	
	public void destroyObject(Object arg0) throws Exception {
		BIOConnection conn = (BIOConnection)arg0;
		conn.close();
	}

	public Object makeObject() throws Exception {
		Socket socket = new Socket();
		InetSocketAddress address = null;
		if(ipAddress == null){
			address = new InetSocketAddress(port);
		}else{
			address = new InetSocketAddress(ipAddress,port);
		}
		
		socket.setSendBufferSize(sendBufferSize * 1024);
		socket.setReceiveBufferSize(receiveBufferSize * 1024);
		socket.setTcpNoDelay(tcpNoDelay);
		socket.setKeepAlive(keepAlive);
		
		if(soTimeout >0){
			socket.setSoTimeout(soTimeout);
		}
		if(coTimeout>0){
			socket.connect(address, coTimeout);
		}else{
			socket.connect(address);
		}
		
		
		BIOConnection conn = new VenusBIOConnection(socket,System.currentTimeMillis());
		byte[] bts = conn.read();
		HandshakePacket handshakePacket = new HandshakePacket();
		handshakePacket.init(bts);
		
		AuthenPacket authen = getAuthenticator().createAuthenPacket(handshakePacket);
		conn.write(authen.toByteBuffer().array());
		bts = conn.read();
		int type = AbstractServicePacket.getType(bts);
		if(type == PacketConstant.PACKET_TYPE_OK){
			if(authenticatorLogger.isInfoEnabled()){
				authenticatorLogger.info("authenticated by server="+ipAddress+":"+port+" success");
			}
		}else if(type == PacketConstant.PACKET_TYPE_ERROR){
			ErrorPacket error = new ErrorPacket();
			error.init(bts);
			if(authenticatorLogger.isInfoEnabled()){
				authenticatorLogger.info("authenticated by server="+ipAddress+":"+port+" error={code="+error.errorCode+",message="+error.message+"}");
			}
			throw new AuthenticationException(error.message,error.errorCode);
		}
		
		return conn;
	}

	public void passivateObject(Object arg0) throws Exception {

	}

	public boolean validateObject(Object arg0) {
		BIOConnection conn = (BIOConnection)arg0;
		if(conn.isClosed()){
			return false;
		}
		if(needPing){
			try {
				conn.write(PING_PACKET.toByteBuffer().array());
				conn.read();
			} catch (IOException e) {
				return false;
			}
		}
		return true;
	}

}
